/* solves the recurrence with constant coefficients
  l[1]*u(n)+l[2]*u(n+1)+...+l[ord+1]*u(n+ord)=l[ord+2]
  return value is a set with the general solution

  Can not yet handle inhomogeneous case

  Example:
>> rec::constant([2,2,1,0],n,2);

                                    n               n
                     {  a1 (- 1 - I)  + a2 (- 1 + I)  }

*/

rec::constant := proc(l, n, ord)
  local eq, cont, x, i, S;
begin
   /* We can not handle the inhomogeneous case,
      variation of constant not yet implemented */
   if l[ord + 2] <> 0 then return({}) end_if;

   /* form the characteristic equation and try to solve it */
   x := genident("x"):
   cont := gcd(op(l));
   eq := _plus(normal(l[i + 1] / cont) * x^i $ i = 0..ord);

   // trivial equation?
   if not has(eq, x) then return({0}) end_if;

   S := solve(eq, x, Multiple, MaxDegree = 4);
   /* strictly, the solution is S union solve(cont=0), but we
      ignore the content */

   /* we do not handle RootOfs, to do! */
   if has(S, RootOf) then return({}) end_if;

   /* construct general solution */
   case type(S)
   of Dom::Multiset do
     return(rec::constant1(S, n, ord));
   of piecewise do
     return(piecewise::extmap(S, rec::constant1, n, ord));
   end_case;
   {}
end_proc:


/* auxiliary function; constructs the general solution of the homogeneous
   equation from a multiset S with the roots of the characteristic equation
   n is the dependent variable, and ord the order of the equation
   the output is a set with one element containing free parameters */
rec::constant1 := proc(S, n, ord)
  local x, i;
begin
  {_plus(x[1]^n * _plus(genident("C") * n^i  $ i = 0..x[2] - 1) $ x in [extop(S)])}
end_proc:
