//    

/*--
	Ci/Series -- the function attribut "series" for Ci
--*/

// Comment: Si is an entire function. 
//          Ci, however, has a branch cut along the
//          negative real axis. Hence, expansions
//          around +- infinity and +-I*infinity are
//          much more complicated to implement than
//          for Si !

Ci::series := proc(e,x,n,dir,opt)
   local l,f,g,a,t,d,s,i, series_one_over_e;
begin

   if dir <> Undirected then // directed expansion
     l:=limit(e,x,dir);
     if l=0 then // formula 5.2.16 
       if n = 0 then
         Series::error("order too small")
       end_if;
       f := Series::Puiseux::create(1, 2, 2*((n + 1) div 2),
                                    Series::gen["Ci"](n), x, 0, dir);
       if e = x then
         return(f + Series::Puiseux::const(EULER + ln(x), x, n + 1, dir))
       else
         return(f @ Series::series(e,x,n,dir,opt)
                + Series::series(EULER + ln(e), x, n + 1, dir, opt))
       end_if
     elif l=infinity or l=-infinity then
       if n = 0 then // shortcut
         if l = infinity then // O(x)
           return(Series::Puiseux::zero(x, 1, dir))
         else // I*PI + O(x)
           return(Series::Puiseux::const(I*PI, x, 1, dir))
         end_if
       end_if;
       // Ci(-x)=I*PI+Ci(x) 
       if l=-infinity then e:=-e; end_if;
       // 5.2.34
       // f := sum((-1)^i * (2*i)! * x^(2*i+1), i = 0..(n-1) div 2)
       if n = 0 then // f := O(x)
         f := Series::Puiseux::zero(x, 1, dir);
       else
         f := Series::Puiseux::create(1, 1, 2*((n + 1) div 2) + 1,
                [(s := 1), (0, (s := -s*(2*i-1)*(2*i))) $ i = 1..(n-1) div 2],
                x, 0, dir);
       end_if;
       // 5.2.35 
       // g := sum((-1)^i * (2*i+1)! * x^(2*i+2), i = 0..(n-2) div 2)
       if n = 1 then // g := O(x^2)
         g := Series::Puiseux::zero(x, 2, dir)
       else
         g := Series::Puiseux::create(1, 2, 2*((n + 2) div 2),
                [(s := 1), (0, (s := -s*(2*i)*(2*i+1))) $ i = 1..(n-2) div 2],
                x, 0, dir);
       end_if;
       if e<>1/x then
         series_one_over_e:=Series::series(1/e,x,n,dir,opt);
         f:=f @ series_one_over_e;
         g:=g @ series_one_over_e
       end_if;
       // 5.2.9
       if l = infinity then
         return(f*sin::series(e, x, n, dir,opt) - g*cos::series(e, x, n, dir,opt));
       else // l = -infinity
         return(f*sin::series(e, x, n, dir,opt) - g*cos::series(e, x, n, dir,opt)
                + I*PI*signIm(-e));
       end_if;
     elif l=I*infinity then
         return(Series::series(
                       // ln(e) - ln(e^2)/2 
                      /*
                       - exp(-I*e)/I/2/e * hypergeom([1/2, 1, 1], [], -4/e^2)
                       - exp(-I*e)/2/e^2 * hypergeom([1, 1, 3/2], [], -4/e^2),
                      */
                      /*
                         (exp(I*e)-exp(-I*e))/2/I/e*_plus((2*i)!  *(-1/e)^i $ i = 0.. n)
                       - (exp(I*e)+exp(-I*e))/2/e^2*_plus((2*i+1)!*(-1/e)^i $ i = 0.. n),
                      */
                         (exp(I*e)-exp(-I*e))/2/I/e * hypergeom([1/2, 1, 1], [], -4/e^2)
                       - (exp(I*e)+exp(-I*e))/2/e^2 * hypergeom([1, 1, 3/2], [], -4/e^2),
                       x, n, dir,opt));
//   elif l=-I*infinity or l = (-I)*infinity then
     elif has(l,infinity) then
         return(Series::series(//ln(e) - ln(e^2)/2 
                      /*
                       - I* PI
                       + exp(I*e)/I/2/e * hypergeom([1/2, 1, 1], [], -4/e^2)
                       - exp(I*e)/2/e^2 * hypergeom([1, 1, 3/2], [], -4/e^2),
                      */
                      /*
                         (exp(I*e)-exp(-I*e))/2/I/e*_plus((2*i)!  *(-1/e)^i $ i = 0.. n)
                       - (exp(I*e)+exp(-I*e))/2/e^2*_plus((2*i+1)!*(-1/e)^i $ i = 0.. n),
                      */
                         (exp(I*e)-exp(-I*e))/2/I/e * hypergeom([1/2, 1, 1], [], -4/e^2)
                       - (exp(I*e)+exp(-I*e))/2/e^2 * hypergeom([1, 1, 3/2], [], -4/e^2),
                       x, n, dir,opt));
     end_if
   end_if;

   // recursively expand the argument
   t := Series::series(e, x, n, dir,opt);

   if domtype(t) = Series::Puiseux then
     d := ldegree(t);
     if d=FAIL then // t = O(..)
	Series::error("order too small")
     end_if;
     if d > 0 then // formula 5.2.16 
       if n = 0 then
         Series::error("order too small")
       end_if;
       f := Series::Puiseux::create(1, 2, 2*((n + 1) div 2),
                                    Series::gen["Ci"](n), x, 0, dir);
       if e = x then
         return(f + Series::Puiseux::const(EULER + ln(x), x, n + 1, dir))
       else
         return(f @ Series::series(e,x,n,dir,opt)
                + Series::series(EULER + ln(e), x, n + 1, dir,opt))
       end_if
     elif d < 0 then
       return(FAIL)
     elif d = 0 then // expansion around a finite point <> 0
       a := lcoeff(t);
       if is(a < 0) = TRUE then
         // expansion on the branch cut
         return(Series::Puiseux::const(-I*PI + signIm(e)*PI*I, x, n, dir)
                + Series::unknown(Ci(e),x,n,dir))
       end_if
     end_if
   end_if;

   Series::unknown(Ci(e),x,n,dir)

end_proc:

// ensure that domain Series is loaded
Series:

// expansion of Ci(x) - EULER - ln(x) around x = 0, formula 5.2.16
// = -x^2/2/2! + x^4/4/4! - x^6/6/6! +- ...
Series::gen["Ci"]:=proc(n) local t, i;
begin
   t:=-1/4;
   [t,(0,(t:=-t*(2*i)/(2*i+1)/(2*i+2)^2))$i=1..(n-3) div 2]
end_proc:
Series::gen["Ci"](1):=[]:
Series::gen["Ci"](2):=[]:
Series::gen["Ci"](3):=[-1/4]:
Series::gen["Ci"](4):=[-1/4]:

// end of file 
