/*--
        Shi::series -- the function attribut "series" for Shi
        
        series expansion of Shi is based on the series expansion of Si:
        Shi(x) = -I * Si(x*I) 
--*/

// Known problems:
// 1) series(Shi(x),x=infinity) fails, because series(Si(x*I),x=infinity) fails
// 2) series(Shi(x),x=-infinity) fails, because series(Si(x*I),x=-infinity) fails
// 3) series(Shi(1/x),x) fails, because series(Si(1/x*I),x) fails

Shi::series:= proc(e, x, n, dir) 
  local s;
begin 
  s := series(-I*Si(e*I), x, n, dir);
  if type(s) = "series" then
     procname(e, x, n, dir)
  else
     // Taylor expansions around x = x0 should look like
     // Shi(x0) + O(x - x0). At this stage, we have
     // -I*Si(I*x0) + O(x - x0).
     // Rewrite such expressions to the target Shi(x0).
     // Further, we want to rewrite
     //     cos(I*x0) = cosh(x0),
     //     sin(I*x0) = I*sinh(x0).
     if has(s, Si) then
        return(subs(s, [hold(Si) = (z -> I*Shi(z/I)),
                             hold(cos) = proc(z) begin
                                          if type(z) = "_mult" and
                                             has([op(z)], I) then
                                                cosh(z/I)
                                          else  cos(z)
                                          end_if;
                                         end_proc,
                             hold(sin) = proc(z) begin
                                          if type(z) = "_mult" and
                                             has([op(z)], I) then
                                                I*sinh(z/I)
                                          else  sin(z)
                                          end_if;
                                         end_proc
                            ],EvalChanges));
     else
        return(s);
     end_if;
  end
end:

// end of file 
