//    

/*--
	Si/Series -- the function attribut "series" for Si
--*/

Si::series := proc(e,x,n,dir,opt)
   local l,f,g,sg,t,d,s,i;
begin

   if dir <> Undirected then // directional expansion
     l:=limit(e,x,dir);
     if l=0 then // formula 5.2.14 
       f := Series::Puiseux::create(1, 1, 2*((n + 1) div 2) + 1,
                                    Series::gen["Si"](n), x, 0, dir);
       if e=x then return(f) else return(f @ Series::series(e,x,n,dir,opt)) end_if
     elif l=infinity or l=-infinity then
       if n = 0 then // O(1)
         return(Series::Puiseux::zero(x, 0, dir))
       end_if;
       // Si(-x)=-Si(x) 
       sg:=(if l=infinity then 1 else e:=-e; -1 end_if);
       // 5.2.34 
       // f := sum((-1)^i * (2*i)! * x^(2*i+1), i = 0..(n-2) div 2)
       if n = 1 then // f := O(x)
         f := Series::Puiseux::zero(x, 1, dir);
       else
         f := Series::Puiseux::create(1, 1, 2*(n div 2) + 1,
                [(s := 1), (0, (s := -s*(2*i-1)*(2*i))) $ i = 1..(n-2) div 2],
                x, 0, dir);
       end_if;
       // 5.2.35 
       // g := sum((-1)^i * (2*i+1)! * x^(2*i+2), i = 0..(n-3) div 2)
       if n <= 2 then // g := O(x^2)
         g := Series::Puiseux::zero(x, 2, dir)
       else
         g := Series::Puiseux::create(1, 2, 2*((n + 1) div 2),
                [(s := 1), (0, (s := -s*(2*i)*(2*i+1))) $ i = 1..(n-3) div 2],
                x, 0, dir);
       end_if;
       if e<>1/x then
         l:=Series::series(1/e,x,n,dir,opt);
         f:=f @ l;
         g:=g @ l
       end_if;
       // 5.2.8 
       return(sg * (Series::Puiseux::const(PI/2, x, n, dir)
              - f*cos::series(e, x, n, dir,opt)
              - g*sin::series(e, x, n, dir,opt)));
     end_if
   end_if;

   // recursively expand the argument
   t := Series::series(e, x, n, dir,opt);

   if domtype(t) = Series::Puiseux then
     d := ldegree(t);
     if d=FAIL then // t = O(..)
	d:=Series::Puiseux::order(t);
        if d > 0 then return(t)
        else
	  Series::error("order too small");
          return(FAIL);
        end_if
     end_if;
     if d > 0 then
       f := Series::Puiseux::create(1, 1, 2*((n + 1) div 2) + 1,
                                    Series::gen["Si"](n), x, 0, dir);
       if e=x then return(f) else return(f @ t) end_if
     elif d < 0 then
       return(FAIL)
     end_if
   end_if;

   Series::unknown(Si(e),x,n,dir)

end_proc:
// ensure that domain Series is loaded
Series:

Series::gen["Si"]:=
proc(n)
  local t, i;
begin
   t:=1;
   [1,(0,(t:=-t*(2*i-1)/(2*i)/(2*i+1)^2))$i=1..(n-1) div 2]
end_proc:
Series::gen["Si"](0):=[]:
Series::gen["Si"](1):=[1]:
Series::gen["Si"](2):=[1]:

// end of file 
