
// handles the call series(arccot(f), x, n, dir)

arccot::series := proc(f,x,n,dir,opt)
   local a, l, t, d;
begin
   //The following yields too complicated results
   //return(series(I/2*(ln(1-I/f) - ln(1+I/f)), x,n));

   if dir <> Undirected then // directional expansion
     l:= limit(f, x, dir);
     if has(l, hold(limit)) or l = undefined then
       return(FAIL)
     elif iszero(l) or has(l, infinity) then
        // use arccot(x) = arctan(1/x)
        return(arctan::series(1/f, x, n, dir, opt))
     end_if
   end_if;

   // recursively expand the argument
   t := Series::series(f, x, n, dir, opt);

   if domtype(t) = Series::Puiseux then
     d := ldegree(t);
     if d = FAIL then
	d:=Series::Puiseux::order(t);
        if d > 0 then
          return(Series::Puiseux::zero(x, 0, dir)) // O(1)
        else
	  Series::error("order too small");
          return(FAIL);
        end_if
     elif d = 0 then
       // expansion around a finite point a <> 0
       a := lcoeff(t);
       if a = I then
         // branch point
         return(Series::series(-I/2*(ln((1/f - I)*I/2) - ln(1 - (1/f - I)*I/2)),
                               x, n, dir, opt))
       elif a = -I then
         // branch point
         return(Series::series(I/2*(ln(-(1/f + I)*I/2) - ln(1 + (1/f + I)*I/2)),
                               x, n, dir, opt))

       elif is(a, Type::Imaginary)  = TRUE then
         // expansion on the branch cut:
         // add correction term; the conjugate is necessary in order
         // to make the expansion correct for x on the imaginary axis
         // as well
         if is(0 < Im(a) < 1) = TRUE then
           return((signIm(conjugate(f)*I) + 1)*PI/2
                  + Series::unknown(arccot(f), x, n, dir))
         elif is(-1 < Im(a) < 0) = TRUE then
           return(-(-signIm(conjugate(f)*I) + 1)*PI/2
                  + Series::unknown(arccot(f), x, n, dir))
         end_if
       end_if
     else // d > 0 or d < 0
       // expansion around 0 or +-infinity: use arccot(x) = arctan(1/x)
       return(arctan::series(1/f, x, n, dir, opt))
     end_if
   end_if;

   Series::unknown(arccot(f),x,n,dir);

end_proc:
