
// handles the call series(arcsinh(f), x, n, dir)

arcsinh::series := proc(f,x,n,dir, opt)
   local s, l, k, t, d, a;
begin

   if dir <> Undirected then // directional expansion
     l:=limit(f, x, dir);
     if has(l, hold(limit)) or l=undefined then
       return(FAIL)
     elif iszero(l) then
       if n<1 
         then s:= []
         else s:= 1; 
              s:=[s,(0,(s:=s*(-1)*(2*k-1)/2/k)/(2*k+1))$k=1..(n+1 div 2)-1]
       end_if;
       s:=Series::Puiseux::create(1,1,2*((n+1) div 2)+1,s,x,0,dir);
       if f=x
         then return(s)
         else return(Series::Puiseux::_fconcat(s,Series::series(f,x,n,dir)))
       end_if;
     elif iszero(l-I) then
       s:=1; l:=1; f:=f-I;
       for k from 1 to n-1 do
         l:=l*f*(2*k-1)/4/k;
         s:=s+I^k*l/(2*k+1)
       end_for;
       return(I*PI/2 -I* Series::series(sqrt(2*I*f)*s,x,n,dir,opt));
     elif iszero(l+I) then
        s:=1; l:=1; f:= I+f;
        for k from 1 to n-1 do
           l:=l*f*(2*k-1)/4/k;
           s:=s+(-I)^k*l/(2*k+1)
        end_for;
        return(-I*PI/2 + I*Series::series(sqrt(-2*I*f)*s,x,n,dir,opt));
     elif has(l, infinity) then
        if l = (-I)*infinity or l=-infinity then
          // due to cancellation in the argument of ln, we need to increase
          // the order
          return(Series::series(ln(f+sqrt(1+f^2)), x, n+1, dir,opt));
        else
          return(Series::series(ln(f+sqrt(f^2+1)), x, n, dir,opt));
        end_if;
     end_if;
  end_if;

  // recursively expand the argument
  t := Series::series(f, x, n, dir,opt);

  if domtype(t) = Series::Puiseux then
    d := ldegree(t);
    if d=FAIL then // t = O(..)
	d:=Series::Puiseux::order(t);
        if d > 0 then return(t)
        else
	  Series::error("order too small");
          return(FAIL);
        end_if;
    end_if;
    if d >= 0 then
      a := coeff(t, x, 0);
      case a
      of 0 do
        if n<1 
          then s:= []
          else s:= 1; 
               s:=[s,(0,(s:=s*(-1)*(2*k-1)/2/k)/(2*k+1))$k=1..(n+1 div 2)-1]
        end_if;
        s:=Series::Puiseux::create(1,1,2*((n+1) div 2)+1,s,x,0,dir);
        if f=x
          then return(s)
          else return(Series::Puiseux::_fconcat(s, t));
        end_if
      of I do
        s:=1; l:=1; f:=I-f;
        for k from 1 to n-1 do
          l:=l*f*(2*k-1)/4/k;
          s:=s+l/(2*k+1)
        end_for;
        return(I*PI/2 - I*Series::series(sqrt(2*I*f)*s,x,n,dir,opt));
      of -I do
        s:=1; l:=1; f:= I+f;
        for k from 1 to n-1 do
           l:=l*f*(2*k-1)/4/k;
           s:=s+(-I)^k*l/(2*k+1)
        end_for;
        return(-I*PI/2 + I*Series::series(sqrt(2*I*f)*s,x,n,dir,opt));
      end_case;
      // expansion on the branch cut (imaginary axis above I and below -I)
      // add correction term for the left/right half plane, respectively
      if is(Re(a)=0, Goal=TRUE) then
        // a is on the imaginary axis
        if is(Im(a)>1, Goal=TRUE) then
          // Im(a) > 1
          return(Series::Puiseux::const(I*PI/2, x, n, dir)
                 + signIm(f)*Series::unknown(arccosh(f),x,n,dir))
        elif (Im(a)<-1, Goal=TRUE) then
          // Im(a) < -1
          return(Series::Puiseux::const(-I*PI/2, x, n, dir)
                 + signIm(f)*Series::unknown(arccosh(-f),x,n,dir))
        end_if
      end_if
    else // ldegree(t) < 0
      return(FAIL);
    end_if
  end_if;

  Series::unknown(arcsinh(f),x,n,dir);

end_proc:
