
// handles the call series(arctan(f), x, n, dir)

arctan::series := proc(f, x, n, dir, opt)
   local s, l, t, d, a, w;
begin

// //The following expansion gives too complicated results
// if nops(s) < 4 then
//    return(series(I/2*ln((1-I*f)-ln(1+I*f)), x, n));
// end_if:

   if dir <> Undirected then // directional expansion
     l:= limit(f,x,dir);
     if has(l, hold(limit)) or l = undefined then
       return(FAIL)
     elif iszero(l) or has(l, infinity) then
       if n<1
         then s:= []
         else s:= 1;
              s:= [s,(0,(s:=-s)/(2*l+1))$l=1..(n + 1 div 2)-1]
       end_if;
       // s := series(arctan(x), x, n);
       s:=Series::Puiseux::create(1,1,2*((n + 1) div 2) + 1,s,x,0,dir);
       if f=x then
         return(s)
       elif iszero(l) then
           return(Series::Puiseux::_fconcat(s,Series::series(f,x,n,dir)))
       elif has(l, infinity) then
           // arctan(x) = signIm(I*x)*PI/2 - arctan(1/x)
           s := Series::Puiseux::_fconcat(s, Series::series(1/f, x, n, dir));
           w := sign(l);
           if not has(w, infinity) and numeric::isnonzero(Re(w)) = TRUE then
             // shortcut; we are approaching complexInfinity along a line
             // not parallel to the imaginary axis ==> signIm(I*f)=signIm(I*w)
             return(Series::Puiseux::const(signIm(I*w)*PI/2, x,
                                           Series::Puiseux::order(s)) - s)
           else
             return(Series::Puiseux::const(signIm(I*f)*PI/2, x,
                                           Series::Puiseux::order(s)) - s)
           end_if
       end_if
     end_if
   end_if;

   // recursively expand the argument
   t := Series::series(f, x, n, dir, opt);

   if domtype(t) = Series::Puiseux then
     d := ldegree(t);
     if d=FAIL then // t = O(..)
	d:=Series::Puiseux::order(t);
        if d > 0 then return(t)
        else
	  Series::error("order too small");
          return(FAIL);
        end_if
     end_if;
     if d > 0 then // expansion around 0
       if n<1
         then s:= []
         else s:= 1;
              s:= [s,(0,(s:=-s)/(2*l+1))$l=1..(n + 1 div 2)-1]
       end_if;
       s:=Series::Puiseux::create(1,1,2*((n + 1) div 2)+1,s,x,0,dir);
       if f=x then
         return(s)
       else
         return(Series::Puiseux::_fconcat(s, t))
       end_if
     elif d = 0 then
       // expansion around a finite point a <> 0
       a := lcoeff(t);
       if a = I then
         // branch point
         return(Series::series(-I/2*(ln((f - I)*I/2) - ln(1 - (f - I)*I/2)),
                               x, n, dir, opt))
       elif a = -I then
         // branch point
         return(Series::series(I/2*(ln(-(f + I)*I/2) - ln(1 + (f + I)*I/2)),
                               x, n, dir, opt))
       elif is(a, Type::Imaginary) = TRUE then
         s := Series::unknown(arctan(f), x, n, dir);
         // expansion on the branch cut:
         // add correction term for the left/right half plane, respectively
         if is(Im(a) > 1) = TRUE then
           return(Series::Puiseux::const(-(-signIm(f*I) + 1)*PI/2, x,
                                         Series::Puiseux::order(s), dir) + s)
         elif is(Im(a) < -1) = TRUE then
           return(Series::Puiseux::const((signIm(f*I) + 1)*PI/2, x,
                                         Series::Puiseux::order(s), dir) + s)
         else
           return(s)
         end_if
       end_if
     else // d < 0, undirected expansion around complexInfinity
       // s := series(arctan(x), x, n);
       if n<1
         then s:= []
         else s:= 1;
              s:= [s,(0,(s:=-s)/(2*l+1))$l=1..(n + 1 div 2)-1]
       end_if;      
       s:=Series::Puiseux::create(1,1,2*((n + 1) div 2) + 1,s,x,0,dir);
       // arctan(x) = signIm(I*x)*PI/2 - arctan(1/x)
       s := Series::Puiseux::_fconcat(s, Series::series(1/f, x, n, dir, opt));
       return(Series::Puiseux::const(signIm(I*f)*PI/2, x,
                                     Series::Puiseux::order(s)) - s)
     end_if
   end_if;

   Series::unknown(arctan(f),x,n,dir);

end_proc:
