/*
 * series attribute of arg - processes series(arg(f1+ I*f2), x, n, dir)
 */

arg::series := proc(f, x, n, dir)
   local l1, l2, f1, f2;
 begin
   f1 := Re(f);
   f2 := Im(f);
   if dir <> Undirected then // directional expansion
     l1:= limit(f1, x, dir);
     if is(l1 > 0) = TRUE then
       return( Series::series(arctan(f2/f1), x, n, dir));
     end_if;
     if is(l1 < 0) = TRUE then
       l2:= limit(f2, x, dir):
       if is(l2 > 0) = TRUE then
         return( Series::series(PI + arctan(f2/f1), x, n, dir));
       end_if:
       if is(l2 < 0) = TRUE then
         return( Series::series(-PI + arctan(f2/f1), x, n, dir));
       end_if:
     end_if:
   else
     userinfo(1, "undirected expansion of arg is not defined");
     return(FAIL);
   end_if;

  // cannot determine position of expansion point.
  // Use  arg(f1, f2) = ln( (f1+I*f2)/sqrt(f1^2 + f2^2) )
  return(Series::series( -I*ln( f/sqrt(f1^2+f2^2)), x, n, dir))

end_proc:
