
ceil::series :=
proc(f,x,n,dir,opt)
  name ceil::series;
  local l, t, d, c;
begin
  if dir <> Undirected then // directional expansion
    l:=limit(f,x,dir);
    if has(l, infinity) then
       // use ceil(f) =  f + frac(-f)
       return( Series::series(f, x, n, dir, opt)
              +Series::Puiseux::const(frac(-f), x, n, dir));
    end_if:
    if domtype(Re(l)) <> DOM_INT then
      l := ceil(l);
      if domtype(Re(l)) = DOM_INT then
        return(Series::Puiseux::const(l, x, n, dir)) // l + O(x^n)
      end_if
    else // Re(l) is an integer
      if dir = hold(Real) then
        userinfo(1,
                 "no real series expansion of ceil(x)".
                 "around discontinuity x = "
                 . expr2text(l));
        return(FAIL)
      else
        // let f = l + c*x^n + higher order terms
        // if n is even and c>0, then ceil(f)= l+1 locally
        // if n is even and c<0, then ceil(f)= l locally
        // if n is odd and c>0, then ceil(f)=l+1 on the right
        //                       and ceil(f)=l on the left
        // if n is odd and c<0, then ceil(f)=l on the  right
        //                       and ceil(f)=l+1 on the left
        t := Series::series(f, x, n, dir, opt);
        if domtype(t) <> Series::Puiseux then
          userinfo(1, "Could not compute series expansion of argument");
          return(FAIL)
        end_if;
        t:= t-l;
        d:= ldegree(t);
        if d = FAIL then
          userinfo(1, "Order of series expansion does not suffice");
          return(FAIL)
        end_if;
        assert(d>0);
        c:= coeff(t, d);
        if d mod 2=0 then
          if is(c>0) = TRUE then
            return(Series::Puiseux::const(l+1, x, n, dir))
          elif is(c<0) = TRUE then
            return(Series::Puiseux::const(l, x, n, dir))
          else
            return(FAIL)
          end_if
        end_if;
        assert(d mod 2 = 1);
        if is(c>0) = TRUE then
          if dir=hold(Right) then
            return(Series::Puiseux::const(l+1, x, n, dir))
          else
            return(Series::Puiseux::const(l, x, n, dir))
          end_if
        elif is(c<0) = TRUE then
          if dir=hold(Left) then
            return(Series::Puiseux::const(l+1, x, n, dir))
          else
            return(Series::Puiseux::const(l, x, n, dir))
          end_if;
        else
          userinfo(1, "Could not determine sign of coefficient");
          return(FAIL)
        end_if;
      end_if;
    end_if;
  end_if;

  // recursively expand the argument
  t := Series::series(f, x, n, dir, opt);
                  
  if domtype(t) = Series::Puiseux then
    d := ldegree(t);
    if d = FAIL then
      Series::error("order too small")
    elif d >= 0 then // expansion around a finite point 
      l := coeff(t, x, 0);
      if domtype(Re(l)) <> DOM_INT and domtype(Im(l)) <> DOM_INT then
        l := ceil(l);
        if domtype(Re(l)) = DOM_INT and domtype(Im(l)) = DOM_INT then
          return(Series::Puiseux::const(l, x, n, dir)) // l + O(x^n)
        end_if
      else
        userinfo(1,
          "no series expansion of ceil(x) around discontinuity x = "
          . expr2text(l));
        return(FAIL);
      end_if
    else // ldegree(t) < 0
      // use ceil(f) =  f + frac(-f)
      return(t + Series::Puiseux::const(frac(-f), x, n, dir))
    end_if
  end_if;

  Series::unknown(ceil(f),x,n,dir)

end_proc:
