/*--
	cot/Series -- the function attribut "series" for cot
--*/

/* 
   cot(x) = 1/x + sum(2^(2n)*(-1)^n/(2*n)!*B[2*n]*x^(2*n-1),n=1..infinity)
   where B = coeff(series(x/(exp(x)-1),x,..) are the Bernoulli numbers
*/

cot::series :=
proc(f,x,n,dir,opt)
  local t,k,a,ts,tc;
begin
  if f=x then
    return(Series::Puiseux::create(
             1, // branchorder
            -1, // leading exponent
             2*((n+1) div 2) - 1, // exponent of O(term)
             Series::gen["cot"](n), // list with n coefficients
             x, // expansion variable
             0,
             dir
          ))
  end_if;
  
  t:=Series::series(f,x,n,dir,opt);
  if domtype(t) <> Series::Puiseux then
    return(FAIL)
  end_if;
  k:=ldegree(t);
  if k=FAIL then // t = O(..)
    k:= Series::Puiseux::order(t);
    if k > 0 then
      return(1/t)
    else
      Series::error("order too small");
    end_if
  elif k>0 then
    Series::Puiseux::_fconcat(
       Series::Puiseux::create(1,-1,2*((n+1) div 2)-1,
                               Series::gen["cot"](n),x,0,dir),
       t)
  elif k=0 then
    a:=lcoeff(t);
    t:=f-a;
    // cot(a+t)= (cot(a)*cot(t) - 1) / (cot(a) + cot(t))
    if traperror(cot(a)) <> 0 then // we've hit a singularity of cot
      Series::series(cos(f),x,n,dir,opt)/
      Series::series(sin(f),x,n,dir,opt);
    else
      if iszero(cot(a)) then
        -1/cot::series(t,x,n,dir,opt)
      else
        t:= cot::series(t,x,n,dir,opt);
        Series::Puiseux::truncate((cot(a)*t -1)/(cot(a) + t), n);
      end_if
    end_if;
  else // expansion around infinity
    if dir <> Undirected then
      // directed expansion
      // a := non-positive order part of t
      a := expr(Series::Puiseux::truncate(t, 0));
      if coeff(t, 0) <> FAIL then
        a := a + coeff(t, 0)
      end_if;
      if traperror(cot(a)) <> 0 then // we've hit a singularity of cot
        Series::series(cos(f),x,n,dir,opt) /
        Series::series(sin(f),x,n,dir,opt)
      elif contains({infinity, -infinity}, limit(a, x, dir)) then
        f := normal(f - a);
        if iszero(f) then
          Series::Puiseux::const(cot(a), x, n, dir);
        else
          // cot(a+t)= (cot(a)*cot(t) - 1)/(cot(a) + cot(t))
          ts := Series::series(cot(f), x, n, dir,opt);
          tc := Series::Puiseux::scalmult(ts, cot(a));
          (Series::Puiseux::scalmult(tc, cot(a))-1) /
           Series::Puiseux::_plus(ts, cot(a))
        end_if;
      else
        userinfo(2, "unable to compute series expansion");
        FAIL
      end_if
    else // undirected expansion
      userinfo(2, "unable to compute series expansion");
      FAIL
    end_if; // dir <> Undirected
  end_if; // case analysis on k
end_proc:

// ensure that domain Series is loaded
Series:

// cot(x) = 1/x +  sum(2^(2n)!*(-1)^n/(2*n)!*B[2*n]*x^(2*n-1),n=1..infinity)
Series::gen["cot"]:=proc(n) 
local i, t;
begin
   t:=1;
   [1, 0, ((t:=-2*t/i/(2*i-1): 
           t*bernoulli(2*i)
          ), 0) $ i=1..(n-1) div 2]
end_proc:
Series::gen["cot"](0):=[]:
Series::gen["cot"](1):=[1]:

// end of file 
