/*=============================================*/
/*  the function attribute "series" for dilog  */
/*=============================================*/

/***************************************************/
dilog::series := proc(f,x,n,dir, opt)
local t,t1,k,lc,i;
begin

  t:=Series::series(f,x,n,dir, opt);
  if type(t)<>Series::Puiseux then return(FAIL) end_if;

  // first, try to expand dilog(f) around f=1: 
  // Use: dilog(f) = sum((1-f)^i/i^2, i=1..infinity).
  t1:= t - Series::Puiseux::one(x, n, dir);  // expansion of f -1
  if type(t1) = Series::Puiseux then
    k:=ldegree(t1);
    if k=FAIL then
      Series::error("order too small");
    elif k>0 // this is indeed an expansion around f=1
    then return(
         Series::Puiseux::_fconcat(
            Series::Puiseux::create(1,1,n,Series::gen["dilog"](n),x,0,dir),
            t1)
         );
    end_if;
  end_if:

  // second: try to expand dilog(f) around f=0: 
  // Use: dilog(f) 
  //    = dilog(0) + int(dilog'(t), t=0..f)
  //    = dilog(0) + int(ln(t)/(1-t), t= 0..f)
  //    = dilog(0) + int(sum(ln(t)*t^i, i=0..infinity), t= 0..f)
  //    = dilog(0) + sum(int(ln(t)*t^i, t=0..f), i=0..infinity)
  //    = dilog(0) + sum(ln(f)*f^(i+1)/(i+1) - f^(i+1)/(i+1)^2, i=0..infinity)
  //    = dilog(0) + sum(ln(f)*f^i/i - f^i/i^2, i=1..infinity)
  t1:= t;  // expansion of f
  k:=ldegree(t1);
  if k=FAIL then
    Series::error("order too small");
  elif k>0 
  then // this is indeed an expansion around f=0
       return(
         Series::series(ln(f)*_plus(f^i/i $ i=1..trunc((n-1)/k))
                + dilog(0) 
                - _plus(f^i/i^2 $ i=1..trunc((n-1)/k)),
                x, n, dir, opt)
               );
  end_if;

  // third: try to expand dilog(f) around f= +/- infinity: 
  // Use the following formula by Landen (27.7.5 of Abramowitz/Stegun)
  // Around +infinity:
  // (if (f not real) or (f real and f>=0)) and |f|>1
  //        dilog(f) = - dilog(1/f) -ln(f)^2/2
  // I.e., for |f|<1, swap f <-> 1/f:
  //        dilog(f) = - dilog(1/f) -ln(1/f)^2/2
  // Around -infinity:
  // if f real and f<0 and |f|>1, i.e., f<-1:
  //        dilog(f) = - dilog(1/f) -ln(f)^2/2 - 2*PI*I*ln(1-1/f)
  // I.e., for |f|<1, swap f <-> 1/f:
  //        dilog(f) = - dilog(1/f) -ln(1/f)^2/2 -2*PI*I*ln(1-f)
  // Note that an expansion around infinity is given by
  // an input f = 1/x or similar.

  if k<0 // this is an expansion around +/-infinity
  then lc:= lcoeff(t1);
       if (lc:= lcoeff(t1)) <> FAIL 
       then k:= -k;
            // The following return value takes care of both 
            // expansions around +infinity as well as -infinity.
            return(
              Series::series(-ln(f)*ln(1-1/f)
                     - dilog(0)
                     + _plus(f^(-i)/i^2 $ i=1..trunc((n-1)/k))
                     - ln(f)^2/2,
                     x, n, dir, opt)
                  );
       end_if;
  end_if;

  // finally, use standard Taylor expansion:
  Series::unknown(dilog(f),x,n,dir)
end_proc:

// ensure that domain Series is loaded
Series:

// dilog(1-z) = polylog(2, z) = sum( z^i/i^2, i=1..infinity ) 
Series::gen["dilog"]:=proc(n) local t,i;
begin t:=1; [((t:=-t)/(i^2)$i=1..n-1)] end_proc:

/**********************************************************************/
