ellipticK::series:=proc(f, z, n, dir, opt)
local z0, x, s, t, k, ph, p, q, r, pp, qq, i, j;
begin  
  x:=genident();

  t:=Series::series(f, z, n, dir, opt);

  // pochhammer symbol:
  ph:=proc(x,n)
  local y,k;
  begin
    y:=1;
    for k from 1 to n do
      y:=y*(x+k-1)
    end;
    return(y);
  end;

  k:=Series::Puiseux::ldegree(t);

  if k>0 then // expansion around 0
    s:=Series::Puiseux::create(1, 0, n,
      [PI/2*ph(1/2,k)^2/(k!)^2 $ k=0..(n-1)], z, 0, dir);

    if f=z then
      return(s);
    else
      return(s @ t);
    end;
  elif k<0 then // expansion around infinity
    s:=Series::Puiseux::create(1, 0, n,
      [ph(1/2,j)^2/(j!)^2*(ln(-1/z)/2+psi(j+1)-psi(1/2-j))/sqrt(-1/z) $ j=0..(n-1)], z, 0, Undirected);

    t:=Series::series(1/f, z, n, Undirected, opt);
    return(s @ t);
  else // k=0
    z0:=lcoeff(t);
    if z0=1 then // expansion around 1
      s:=Series::Puiseux::create(1, 0, n,
        [(-1)^j*ph(1/2,j)^2/(j!)^2*(-ln(1-z)/2+psi(j+1)-psi(j+1/2)) $ j=0..(n-1)], z, 1, dir);

      return(s @ t);
    else // expansion around any other point
      s:=[];
      p:=1;
      q:=0;
      r:=1;
      for i from 0 to n do
        // Loop invariant:
        // subs(diff(ellipticK(x), x$i), x=z0) = subs(ellipticK(x)*p+ellipticE(x)*q, x=z0)/r

        pp:=subs(p, x=z0);
        qq:=subs(q, x=z0);

        if Re(z0)>1 and Im(z0)=0 then // z0 is on the branch cut
          s:=append(s, (ellipticK(z0)*pp+ellipticE(z0)*qq+(signIm(z)+1)*I*(ellipticCK(z0)*(pp+qq)-ellipticCE(z0)*qq))/r);
        else
          s:=append(s, (ellipticK(z0)*pp+ellipticE(z0)*qq)/r);
        end;
        
        [p, q]:=expand(
          [(2*i-x-4*i*x+1)*p+(1-x)*q+2*x*(x-1)*diff(p, x),
           (2*i+x-4*i*x-1)*q-p+2*x*(x-1)*diff(q, x)]);
        r:=r*2*z0*(z0-1)*(i+1);
      end;
  
      s:=Series::Puiseux::create(1, 0, n, s, z, z0, dir);
  
      return(s @ t);
    end;
  end;
end_proc:


