//    

/*--
	erf/Series -- the function attribut "series" for erf
	analogous to erfc::series
--*/

erf::series := proc(f,x,n,dir, opt)
  local t,s,d,k;
begin

   // recursively expand the argument
   t:=Series::series(f,x,n,dir, opt);

   if domtype(t) = Series::Puiseux then
     d := ldegree(t);
     if d = FAIL then // t = O(..)
	d:=Series::Puiseux::order(t);
        if d > 0 then return(t)
        else
	  Series::error("order too small");
          return(FAIL);
        end_if
     elif d < 0 then // f goes to +/-infinity 
       s := FAIL;
       if dir <> Undirected then
         s := limit(lmonomial(t), x, dir);
         if s = FAIL or type(s) = "limit" then
           s := FAIL
         elif domtype(s) = Dom::Interval then
           s := op(sign(s))
         else
           s := sign(s)
         end_if;
       end_if;
       if s=1 then // +infinity 
         s:=Series::Puiseux::create(1,1,n+1,Series::gen["erf"](n),x);
         s:=Series::Puiseux::_fconcat(s, 1/t);
         return(1 - s * Series::series(exp(-f^2), x, n, dir))
       elif s=-1 then // -infinity 
         s:=Series::Puiseux::create(1,1,n+1,Series::gen["erf"](n),x);
         s:=Series::Puiseux::_fconcat(s, -1/t);
         return(-1 + s * Series::series(exp(-f^2), x, n, dir))
       elif s = I then // +I*infinity 
         s:=Series::Puiseux::create(1,1,n+1,Series::gen["erf"](n),x);
         s:=Series::Puiseux::_fconcat(s, -1/t);
         return(s * Series::series(exp(-f^2), x, n, dir))
       elif s = -I then // - I*infinity
         s:=Series::Puiseux::create(1,1,n+1,Series::gen["erf"](n),x);
         s:=Series::Puiseux::_fconcat(s, -1/t);
         return(s * Series::series(exp(-f^2), x, n, dir))
       else 
	 userinfo(2,"unable to compute expansion");
         return(FAIL)
       end_if
     elif d > 0 then // expansion around 0
       // s := series(erf(x), x)
       // = 2/sqrt(PI) * sum( (-1)^k/(2k+1)/k! * x^(2k+1) )
       s := 2/sqrt(PI);
       s := [s, (0, (s := -s*(2*k - 1)/(2*k + 1)/k))
                   $ k = 1..((n - 1) div 2)];
       s := Series::Puiseux::create(1, 1, n + 1, s, x, 0, dir);
       if f = x then
         return(s)
       else
         return(Series::Puiseux::_fconcat(s, t))
       end_if
     end_if
   end_if;

   Series::unknown(erf(f),x,n,dir)

end_proc:

// ensure that domain Series is loaded
Series:

// expansion of erfc(x)*exp(x^2) around infinity, leading order is 1
// This is identical to Series::gen["erfc"]
Series::gen["erf"]:=proc(n) local t,i;
begin
   t:=1/sqrt(PI);
   [t,(0,(t:=-t*(2*i-1)/2))$i=1..(n-1) div 2]
end_proc:

// end of file 
