/*--
  erfc/Series -- the function attribut "series" for erfc(x) and erfc(x, n) 

Extension to 2 argument version: Sept. 08 by W. Oevel
--*/

erfc::series := proc(f, n, x, ord, dir, opt)
  local t,s,d,k,p;
begin
   if args(0) = 5 then
      [n, x, ord, dir, opt]:= [0, n, x, ord, dir];
   end_if:
   if has(n, x) then 
      return(FAIL);
   end_if:
   // recursively expand the argument
   t:=Series::series(f,x,ord,dir, opt);
   if domtype(t) = Series::Puiseux then
     d := ldegree(t);
     if d = FAIL then // t = O(..)
	d:=Series::Puiseux::order(t);
        if d > 0 then return(1+t)
        else
	  Series::error("order too small");
          return(FAIL);
        end_if
     elif d < 0 then // f goes to +/-infinity 
       s := FAIL;
       if dir <> Undirected then
         s := limit(lmonomial(t), x, dir);
         if s = FAIL or type(s) = "limit" then
           s := FAIL
         elif domtype(s) = Dom::Interval then
           s := op(sign(s))
         else
           s := sign(s)
         end_if
       end_if;
       if s=1 then // +infinity 
         if domtype(n) = DOM_INT then
           s:= Series::Puiseux::create(1,n+1,ord+n+1,Series::gen["erfc"](n, ord),x);
           s:= Series::Puiseux::_fconcat(s, 1/t);
           return(s * Series::series(exp(-f^2), x, ord, dir));
         else
           // Puiseux::_fconcat does not work for symbolic n. Use gen2 to
           // generate an expression that is expanded into a gseries:
           s:= Series::series(Series::gen2["erfc"](n, ord, f), x, ord, dir, opt):
           return(s):
         end_if:
       elif s=-1 then // -infinity 
         // The identity
         //  erfc(x, n) = - (-1)^n*erfc(-x, n) +  2*(-1)^n/I^n/2^n/n!* hermite(n, I*x)
         // is used to trace -infinity to infinit:
         if domtype(n) = DOM_INT then
           p:= normal((-1)^n*2/n!/2^n/I^n*orthpoly::hermite(n, I*f)):
           // if the requested order is larger than n, the exponential
           // series must be added to the (exact) polynomial part:
           if ord > n then
              p:= p - (-1)^n * Series::gen2["erfc"](n, if n <= 0 then
                                                          ord-n-1
                                                       elif n <= 2 then
                                                          ord-n
                                                       else
                                                          ord-n + 1
                                                       end_if, -f):
           end_if:
           return(Series::series(p, x, ord, dir));
         else
           return(FAIL);
         end_if;
       elif s = I then // +I*infinity
         if iszero(n) then
           s:= Series::Puiseux::create(1,n+1,ord+n+1,Series::gen["erfc"](n, ord),x);
           s:= Series::Puiseux::_fconcat(s, -1/t);
           return(1 - s * Series::series(exp(-f^2), x, ord, dir))
         else
           return(FAIL);
         end_if;
       elif s = -I then // - I*infinity
         if iszero(n) then
           s:= Series::Puiseux::create(1,n+1,ord+n+1,Series::gen["erfc"](n, ord),x);
           s:= Series::Puiseux::_fconcat(s, -1/t);
           return(1 - s * Series::series(exp(-f^2), x, ord, dir))
         else
           return(FAIL);
         end_if;
       else 
	 userinfo(2,"unable to compute expansion");
         return(FAIL)
       end_if

     elif d > 0 then // expansion around 0

       s:= [if domtype((n-k)/2) = DOM_INT and n - k <= -2 then 
               0
             else 
               (-1)^k/2^(n-k)/k!/gamma((n-k)/2 + 1)
             end_if $ k = 0..ord-1];
       s := Series::Puiseux::create(1, 0, ord, s, x, 0, dir);
       if f = x then
         return(s)
       else
         return(Series::Puiseux::_fconcat(s, t))
       end_if
     end_if
   end_if;

   Series::unknown(erfc(f, n), x, ord,dir)

end_proc:

// ensure that domain Series is loaded
Series:

// expansion of erfc(x)*exp(x^2) around infinity, leading order is 1
// For n = 0 this is identical with Series::gen["erf"]
Series::gen["erfc"]:=proc(n, ord) local t,i;
begin
   t:=1/sqrt(PI)/2^n;
   [t,(0,(t:=-t*(n + 2*i - 1)*(n + 2*i)/4/i)) $ i=1..(ord-1) div 2]
end_proc:

// Here is the asymptotic formula of erfc(f, n) as an expression.
Series::gen2["erfc"]:=proc(n, ord, f) local k;
begin
   _plus(exp(-f^2)/sqrt(PI)*
         (-1)^k*(n + 2*k)!/n!/k!/2^(n + 2*k)*(1/f)^(2*k + n + 1) 
         $ k = 0..ord-1);
end_proc:

// end of file 
