/*--
	exp/Series -- the function attribut "series" for exp
--*/

exp::series :=
proc(f, x, n, dir: DOM_IDENT, opt: DOM_TABLE)
  local s, f0, a, g, t, tt, v, l, p, k, q, l1, splitProduct;
begin
  s := Series::Puiseux::create(1, 0, n, Series::gen["exp"](n), x, 0, dir);
  if f = x then
    s
  else
    // recursively expand the argument
    t := Series::series(f, x, n, dir, opt);
    if domtype(t) <> Series::Puiseux then
      return(FAIL)
    end_if;

    v := Series::Puiseux::ldegree(t);
    if v = FAIL then // exp(O(...))
      v := Series::Puiseux::order(t);
      if v > 0 then
        Series::Puiseux::one(x, n, dir) + t	// exp(O(x))=1+O(x)
//         elif v = 0 then
//           t					// exp(O(1))=O(1) 
// commented out, since O(1) might in fact represent ln(x) ...
      else // precision too low
        Series::error("order too small");
      end_if

    elif v > 0 then // expansion around 0
      Series::Puiseux::_fconcat(s, t)

    elif v < 0 then // exp(1/x^v + ...), expansion around +-infinity
      if opt[UseGseries] and contains({Left, Right}, dir) then // directional expansion
        // f0 := negative order part of t
        f0 := expr(Series::Puiseux::truncate(t, 0));
        f := normal(f - f0, Expand = TRUE);
        if iszero(f) then
          tt := null();
        elif has(f, x) then
          tt := Series::series(exp(f), x, n, dir, opt);
        else 
          tt := exp(f):
        end_if;
        tt * Series::gseries::new(expand(exp(f0)), x, n, dir) // try MRVasympt
      else // undirected expansion
        FAIL
      end_if;

    else // v = 0
      // expansion around a finite point <> 0
      // exp(f0+(f-f0)) = exp(f0)*exp(f-f0)
      f0 := Series::Puiseux::lcoeff(t);
      
      // tt := series of exp(f-f0)
      tt := Series::Puiseux::_fconcat(s,
                                      Series::Puiseux::lmonomial(t, Rem)[2]);
      if tt = FAIL then
        return(FAIL)
      end_if;

      // p collects the part of exp(f0) depending on x,
      // a collects the part depending not or at most "harmlessly"
      // on x, i.e., in the form signIm
      p := 1;
      a := 1;
      if not has(f0, x) then
        a := exp(f0);
      else // try to get rid of logs in f0

        g := normal(f0, Expand = TRUE);
        if type(g) = "_plus" then
          l := [op(g)];
        else
          l := [g];
        end_if;
        // now f0 = _plus(op(l))
        
        // auxilliary procedure splitProduct
        // splits elements of l in the form k*ln(m) with k
        // not depending on x or at most containing signIm,
        // if possible, and returns FAIL otherwise
        splitProduct :=
        proc(e)
        begin
          case type(e)
            of "ln"     do
              [1, e]; break
            of "signIm" do
              [e, 1]; break
            of "_power" do
              if not has(op(e, 2), x) and type(op(e, 1)) = "signIm" then
                [e, 1]
              else
                FAIL
              end_if;
              break
            of "_mult"  do
              if has(e, x) then
                e := split(e, has, x);
                case type(e[1])
                  of "ln"     do
                    [e[2], e[1]];   break
                  of "signIm" do
                    [e[2]*e[1], 1]; break
                  of "_power" do
                    if not has(op(e[1], 2), x)
                      and type(op(e[1], 1)) = "signIm" then
                      [e[2]*e[1], 1]
                    else
                      FAIL
                    end_if;
                    break
                  otherwise
                    FAIL
                end_case
              else // not has(e, x)
                e := split(e, has, ln);
                if type(e[1]) = "ln" then
                  [e[2], e[1]]
                elif type(e[1]) = "_mult" then
                  // there are several logarithms with constant term;
                  // just select the first one
                  [e[2]*e[1]/op(e[1], 1), op(e[1], 1)]
                else
                  [e[2]*e[1], 1]
                end_if
              end_if;
              break
            otherwise
              if not has(e, x) then
                [e, 1]
              else
                FAIL
              end_if
          end_case
        end_proc;
        l := map(l, splitProduct);
        if contains(l, FAIL) > 0 then
          // f0 contains some function depending on x that is not
          // ln or signIm; we can't handle this
          return(FAIL)
        end_if;
        // Now f0 = _plus(op(l[i], 1)*op(l[i], 2), i = 1..nops(l)),
        // the op(l[i], 2) are either logarithms or 1,
        // and the op(l[i], 1) depend at most "harmlessly" on x
        // (i.e., in the form signIm)

        // make all summands of the form k*ln(m) to factors
        // m^k of the resulting series
        while nops(l) > 0 do
          l1 := op(l[1], 2);
          if type(l1) = "ln" then
            // collect all terms of the form ln(op(l1))
            l := split(l, z -> op(z, 2) = l1);
            k := _plus(op(map(l[1], op, 1)));
            l := l[2];
          else
            k := op(l[1], 1);
            delete l[1];
          end_if;
          
          if not has(l1, x) then
            // a := a * exp(k*l1)
            if type(l1) = "ln" then
              a := a * op(l1)^k
            else
              a := a * exp(k*l1)
            end_if
          else
            // l1 = ln(foo), foo contains x
            // p := p * series(l1^k, x)
            if testtype(k, Type::Rational) then
              q := Series::series(op(l1)^k, x, n, dir, opt);
            else
              if opt[UseGseries] then
                // !!! this yields nonsense, e.g., if l1 = 2*x or x+1
                q := Series::gseries::create([[1, op(l1)^k]], 0, x = 0);
              else
                return(FAIL)
              end_if
            end_if;
            if p = 1 then
              // this is necessary since 1 * Series::gseries does not work
              p := q;
            elif traperror((p := p * q)) <> 0 then
              // gseries could not multiply
              return(FAIL);
            end_if;
          end_if;
        end_while;
      end_if;
      // exp(f0) = p * a, where a contains x at most harmlessly
      
      // p := p * a
      if domtype(p) = Series::Puiseux then
        p := Series::Puiseux::scalmult(p, a, 0);
      elif domtype(p) = Series::gseries then
        p := Series::gseries::scalmult(p, a, 1);
        tt := Series::gseries::convert(tt);
        if tt = FAIL then
          return(FAIL)
        end_if;
      else
        p := p * a
      end_if;

      // final result: exp(f - f0) * exp(f0) = tt * p
      if iszero(combine(f - f0, ln)) then
        // f = f0 = p
        if contains({Series::Puiseux, Series::gseries}, domtype(p)) then
          return(map(p, combine, exp))
        else
          return(Series::Puiseux::const(combine(p, exp), x, n, dir))
        end_if
      elif traperror((tt := tt * p)) <> 0 then
        // gseries could not multiply
        return(FAIL);
      end_if;
      return(map(tt, combine, exp))
    end_if;
  end_if
end_proc:

// ensure that domain Series is loaded
Series:

Series::gen["exp"]:=proc(n) local t,i;
begin
   t:=1; [1,(t:=t/i)$i=1..n-1]
end_proc:
Series::gen["exp"](0):=[]:

// end of file 
