/*--
	harmonic/Series -- the function attribut "series" for harmonic
--*/

harmonic::series := proc(f,x,ord,dir, opt) // series(harmonic(f),x,ord,dir) 
  local l,lim,k,s,d;
begin
   if dir <> Undirected then // directed expansion
     if (lim := Re(limit(f,x=0,dir))) = infinity then
       f:= f + 1;
       // expansion at infinity 
       l:=[-1/2/f,-bernoulli(2*k)/2/k*f^(-2*k)$k=1..(ord-1) div 2];
       if nops(l)>ord then delete l[ord+1] end_if;
       return(Series::series(_plus(EULER, ln(f), op(l)), x, ord, dir, opt))
     elif lim = -infinity then // expansion at -infinity
         // harmonic(x) = harmonic(-x) + 1/x - PI*cot(PI*f)
         return(Series::series(harmonic(-f) + 1/f - PI*cot(PI*f),
                               x, ord, dir, opt))
     end_if;
   end_if;

   // recursively expand the argument
   s:=Series::series(f, x, ord, dir);

   if domtype(s) = Series::Puiseux then
     d := ldegree(s);
     if d = FAIL then // s = O(..)
       Series::error("order too small");
     elif d < 0 then
       return(FAIL)
     elif is(coeff(s, x, 0), Type::NegInt) = TRUE then
       // expansion around simple pole, use reflection formula
       //  harmonic(x) = harmonic(-x) + 1/x - PI * cot(PI*x)
       return(Series::series(harmonic(-f) + 1/f - PI * cot(PI*f),
                            x, ord, dir, opt))
     end_if
   end_if;
 
   Series::unknown(harmonic(f),x,ord,dir)

end_proc:

// end of file 
