/*--
        igamma/Series -- the function attribut "series" for igamma
--*/

igamma::series :=
proc(a,f,x,n,dir, opt)
   local l, k, P, s0, s, t, tt, d;
begin

  // the formulas used below from Abramowitz/Stegun are only valid if
  // a is constant
  // TODO:
  // - expansions with respect to the first argument
  // - formula 6.5.35 in Abramowitz/Stegun
  if has(a,x) or not contains({DOM_FLOAT, DOM_COMPLEX}, type(float(a))) then
    return(FAIL)
  end_if;

  if dir <> Undirected then // directional expansion
    l:=limit(f,x,dir);
    if iszero(l) then
      // use expansion in 0:
      // i.e. Abramowitz and Stegun 6.5.29
      // with 6.5.3. and 6.5.4.
      t:=x^a/a;
      s0:=t;
      s:=_plus(s0,(t:=-t*x/(a+k)/k*(a+k-1))$ k=1..trunc(n));
      //apply 6.5.3
      s:=gamma(a)-s;
// More efficient: use create !!!
      s:=Series::series(s,x,n,dir, opt);
      if f = x then
        return(s)
      else
        return(s @ Series::series(f,x,n,dir, opt))
      end_if:
    elif l=infinity then
      // use asymptotic expansion of A and S eq. 6.5.32
      // changed z into 1/x (z->infinity when x->0, Right)
      t:=1:
      P:=[1,(t:=t*(a-k))$ k=1..(n - 1)]:
      P := Series::Puiseux::create(1, 0, n, P, x, 0, dir):
      if f<>1/x then
        s:=Series::series(1/f,x,n,dir, opt);
        //------------------------------------------------
        // quick hack by Walter:
        // series(igamma(x, ln(x), x = infinity) yields an
            // error caused by the following decomposition.
            // --> use traperror as a fast hack
            //------------------------------------------------
            if traperror((P:=P @ s)) <> 0 then
              return(FAIL)
            end_if;
         end_if;
         return(Series::series(f^(a-1)*exp(-f), x, n, dir, opt) * P);
      end_if
   end_if;

   // recursively expand the argument
   tt := Series::series(f, x, n, dir, opt);

   if domtype(tt) = Series::Puiseux then
     d := ldegree(tt);
     if d = FAIL then // tt = O(..)
       d := Series::Puiseux::order(tt);
       if d > 0 then
         // uses Puiseux::_power
         return(gamma(a) + tt^a)
       else
         Series::error("order too small")
       end_if
     elif d > 0 then // expansion around 0
         // use expansion in 0: 
         // i.e. Abramowitz and Stegun 6.5.29
         // with 6.5.3. and 6.5.4.
         t:=x^a/a;
         s0:=t;
         s:=_plus(s0,(t:=-t*x/(a+k)/k*(a+k-1))$ k=1..trunc(n));
         //apply 6.5.3
         s:=gamma(a)-s;
// More efficient: use create !!!
         s:=Series::series(s,x,n,dir, opt);
         if f = x then
           return(s)
         else
           return(s @ tt)
         end_if:
     elif d < 0 then
       return(FAIL)
     end_if
   end_if;
 
   Series::unknown(igamma(a,f),x,n,dir)

end_proc:
