/*--
inverf::series -- the function attribut "series" for inverf
--*/

inverf::series := proc(f,x,n,dir, opt)
  local t, s, d, l, mydir;
begin

   // recursively expand the argument
   t:=Series::series(f,x,n,dir, opt);

   if domtype(t) = Series::Puiseux then
     d := ldegree(t);
     if d = FAIL then // t = O(..)
	d:=Series::Puiseux::order(t);
        if d > 0 then 
          return(t)
        else
	  Series::error("order too small");
          return(FAIL);
        end_if
     end_if;
     if d < 0 then // f goes to +/-infinity 
        userinfo(2,"unable to compute expansion");
        return(FAIL)
     end_if;
     if d = 0 then // f goes to some constant
       mydir:= if contains({Left, Right, Real}, dir) then
          dir
       else
          null();
       end_if:
       l:= limit(f, x = 0, mydir);
       if iszero(l) then
          d:= 1;
          // proceed to the case d > 0 (expansion around 0)
       end_if;
     end_if;
     if d > 0 then // expansion around 0
       s := Series::Puiseux::create(1,1,n+1,
                  Series::gen["inverf"](n), x, 0, dir);
       if f = x then
         return(s)
       else
         return(Series::Puiseux::_fconcat(s, t))
       end_if;
     end_if;
   end_if;
   Series::unknown(inverf(f),x,n,dir)
end_proc:

// ensure that domain Series is loaded
Series:

// the coeffs of the expansion of inverf(x) around x = 0:
// inverf(x) = sum(c(k)/(2*k+1)*(sqrt(PI)/2*x)^(2*k+1), k = 0 .. infinity)
// with coefficients c(k) given by the recusion
//   c(0) = 1,  c(n) = _plus(c(k)*c(n-1-k)/(k+1)/(2*k+1) $ k = 0..n-1).
Series::gen["inverf"]:=
proc(n) 
 local t, i, c;
begin
   c:= proc(n) 
       local k; 
       option remember;
       begin
         if n = 0 then 
            return (1);
         else
            return(_plus(c(k)*c(n-1-k)/(k+1)/(2*k+1) $ k = 0..n-1));
         end_if;
       end_proc:
   [PI^(1/2)/2,(0,(t:= PI^(i+1/2)/2^(2*i+1)*c(i)/(2*i+1)))$i=1..(n-1) div 2]
end_proc:

// end of file 
