/*====================================================================*/
/*   polylog/Series -- the function attribute "series" for polylog    */
/*====================================================================*/

/**********************************************************************/
/*
 *  For series(polylog(p,f(x))) at the order n.
 */
/**********************************************************************/
polylog::series :=
proc(p,f,x,n,dir, opt) 
  local l,t,d;
begin

   //---------------------------------------------------
   // The series attribute of dilog is quite sophisticated.
   // Use it, if p = 2 (polylog(2,x) = dilog(1-x))
   //---------------------------------------------------
   if p=2 then 
      return(Series::series(dilog(1-f), x, n, dir, opt)) 
   end_if:

   //---------------------------------------------------
   // The following cases have to be considered:
   // a) f = +/- infinity  (asymptotic expansion)
   // b) f = 1, n >= p - 1 (because in the Taylor-Formula,
   //        derivatives of polylog(p, x) involve
   //        ln(1 - x) 
   // c) Special code for Taylor expansions around f = 0 is
   //    needed because derivatives of polylog(p, x) yield
   //    polylog(x)/x = 0/0 for x = 0.
   //---------------------------------------------------

   if dir <> Undirected then // directional expansion
     if domtype(p) <> DOM_INT then
        return(FAIL);
     end_if;
     l:= limit(f, x, dir);
     if has(l, infinity) then
       // --------------------------------------------------------------
       // For Im(f) = 0,  |f| > 1,  the following identity holds:
       //  Li(p, f) = -(-1)^n Li(p, 1/f) 
       //                - (-2*PI*I)^p/p!*bernoulli(p, ln(1/f)/2/PI/I)
       // See SPECFUNC/TEST/polylog.tst
       // Use this identity the reduce the asymptotic expansion
       // around f = +- infinity to the expansion around f = 0:
       // --------------------------------------------------------------
       if sign(l) = 1 then
            // Use ln(1/f) = - ln(f) if f > 0 ?
            f:= expand(
                 - (-1)^p*polylog(p, 1/f) 
                 - (-2*PI*I)^p/p!*bernoulli(p, ln(1/f)/2/PI/I)
                );
            return(Series::series(f,x,n,dir, opt))
       elif sign(l) = - 1 then
            // Simplify the computation by using
            // ln(1/f) = 2*PI*I - ln(f) if f < 0
            // bernoulli(p, 1 - z) = (-1)^p*bernoulli(p, z)
            f:= expand( 
                 - (-1)^p*polylog(p, 1/f) 
                 - (2*PI*I)^p/p!*bernoulli(p, ln(f)/2/PI/I)
                );
            return(Series::series(f,x,n,dir, opt));
       elif is(Im(l) <= 0) = TRUE then
            f:= expand( 
                 - (-1)^p*polylog(p, 1/f) 
                 - (-2*PI*I)^p/p!*bernoulli(p, ln(1/f)/2/PI/I)
                );
            return(Series::series(f,x,n,dir, opt));
       elif is(Im(l) > 0) = TRUE then
            f:= expand( 
                 - (-1)^p*polylog(p, 1/f) 
                 - (-2*PI*I)^p/p!*bernoulli(p, ln(1/f)/2/PI/I)
                 + 2*PI*I*ln(f)^(p-1)/(p-1)!
                );
            return(Series::series(f,x,n,dir, opt));
       end_if;
       return(FAIL);
     end_if; // has(l, infinity)
     //------------------------------------------------
     if iszero(l) then
       l:= Series::Puiseux::create(1,1,n,Series::gen["polylog"](p,n),x,0,dir):
       if f=x then 
         return(l)
       else
         t:=Series::series(f,x,n,dir, opt);
         if type(t)<>Series::Puiseux then
           return(FAIL)
         else
           return(Series::Puiseux::_fconcat(l, t));
         end_if;
       end_if;
     end_if;
     //------------------------------------------------
     if iszero(l-1) then
        // insert code for expansions of polylog(p, f)
        // around f = 1 here.
     end_if;
     return(FAIL) 
   end_if;

   //-------------------------------
   // Taylor expansion around f = 0
   //-------------------------------
   // recursively expand the argument
   t := Series::series(f, x, n, dir, opt);

   if domtype(t) = Series::Puiseux then
     d := ldegree(t);
     if d = FAIL then // t = O(..)
       d := Series::Puiseux::order(t);
       if d > 0 then
         return(t);
       else
         Series::error("order too small");
       end_if       
     elif d > 0 then // expansion around 0
       l:= Series::Puiseux::create(1,1,n,Series::gen["polylog"](p,n),x,0,dir):
       if f=x
       then return(l)
       else return(Series::Puiseux::_fconcat(l, t));
       end_if
     elif d < 0 then
       return(FAIL)
     end_if
   end_if;

   //---------------------------------------
   // Taylor expansion around f <> 1.
   // Use Taylor formula via Series::unknown
   //---------------------------------------
   Series::unknown(polylog(p,f),x,n,dir)

end_proc:

// ensure that domain Series is loaded
Series:

//-------------------------------------------------------------------
//  Expansion for polylog(p,t) at the order n. 
//-------------------------------------------------------------------
Series::gen["polylog"]:=proc(p,n) local t,i; begin
   t:=1; [((t:=t)/(i^p)$i=1..n-1)]
end_proc:
//-------------------------------------------------------------------
