//    

/*--
	psi/Series -- the function attribut "series" for psi
--*/

psi::series := proc(f,n,x,ord,dir, opt) // series(psi(f,n),x,ord,dir) 
  local l,lim,k,s,d;
begin

   if dir <> Undirected then // directed expansion
     if (lim := Re(limit(f,x=0,dir))) = infinity then
       // expansion at infinity 
       if n=0 then // formula 6.3.18 in Abramowitz & Stegun 
         l:=[-1/2/f,-bernoulli(2*k)/2/k*f^(-2*k)$k=1..(ord-1) div 2];
         if nops(l)>ord then delete l[ord+1] end_if;
         return(Series::series(_plus(ln(f), op(l)), x, ord, dir, opt))
       elif domtype(n) = DOM_INT then // formula 6.4.11 in Abramowitz & Stegun
         s:=(-1)^(n-1);
         l:=[s*fact(n-1),s*fact(n)/2,
                (s*bernoulli(2*k)*fact(2*k+n-1)/fact(2*k),0)
		    $ k=1..(ord-1) div 2];
         if nops(l)>ord then delete l[ord+1] end_if;
         return(Series::Puiseux::create(1,n,n+ord,l,x,0,dir)
                @ Series::series(1/f, x, ord, dir, opt))
       end_if
     elif lim = -infinity then // expansion at -infinity
       if domtype(n) = DOM_INT then
         // use nth derivative of reflection formula
         // psi(x) = psi(1 - x) - PI * cot(PI*x)
         return(Series::series((-1)^n*psi(1 - f, n)
                               - PI^(n + 1) * D([1 $ n], cot)(PI*f),
                               x, ord, dir, opt))
       else
         // unfortunately, we cannot do this for a symbolic second
         // exponent, since there is no means to express an nth formal
         // derivative for symbolic n
         userinfo(1, "cannot compute series expansion for symbolic second argument of psi");
         return(FAIL)
       end_if;
       return(FAIL)
     end_if;
   end_if;

   // recursively expand the argument
   s:=Series::series(f, x, ord, dir);

   if domtype(s) = Series::Puiseux then
     d := ldegree(s);
     if d = FAIL then // s = O(..)
       Series::error("order too small");
//     elif d > 0 then // expansion in zero 
//       // use formula 6.4.6 of Abramowitz & Stegun 
//       return(series(-(-1)^n*fact(n)/f^(n+1)+psi(f+1,n),x,ord,
//                     if dir = Undirected then null() else dir end_if))
     elif d < 0 then
       return(FAIL)
     elif /* d >= 0 and */ is(-coeff(s, x, 0), Type::NonNegInt) = TRUE then
       // expansion around simple pole, use nth derivative of reflection
       // formula psi(x) = psi(1 - x) - PI * cot(PI*x)
       if domtype(n) = DOM_INT then
         return(Series::series((-1)^n*psi(1 - f, n)
                               - PI^(n + 1) * D([1 $ n], cot)(PI*f),
                               x, ord, dir, opt))
       else
         // unfortunately, we cannot do this for a symbolic second
         // exponent, since there is no means to express an nth formal
         // derivative for symbolic n
         userinfo(1, "cannot compute series expansion for symbolic second argument of psi");
         return(FAIL)
       end_if
     end_if
   end_if;
 
   Series::unknown(psi(f,n),x,ord,dir)

end_proc:

// end of file 
