
round::series :=
proc(f,x,n,dir, opt)
  name round::series;
  local l, t, d;
begin

  if dir <> Undirected then // directional expansion
    l:=limit(f,x,dir);
    if has(l, infinity) then
      // use round(f) = floor(f+1/2) = f + 1/2 - frac(f+1/2)
      // = -ceil (-f-1/2)
      return( Series::series(f + 1/2, x, n, dir, opt)
             -Series::Puiseux::const(frac(f+1/2), x, n, dir))
    end_if:

    
    if domtype(Re(l) - 1/2) <> DOM_INT then
      l := round(l);
      if domtype(Re(l)) = DOM_INT then
        return(Series::Puiseux::const(l, x, n, dir)) // l + O(x^n)
      end_if
    else // Re(l) - 1/2 is an integer
      if dir = Real then
        userinfo(1,
                 "no real series expansion of round(x) around discontinuity x = "
                 . expr2text(l));
        return(FAIL)
      end_if;

      // since floor::series would call ceil::series here, we call
      // ceil::series directly
      t:= ceil::series(-f-1/2, x, n, dir, opt);
      if t = FAIL then
        return(FAIL)
      else
        return(-t)
      end_if;
    end_if;
  end_if;

  // recursively expand the argument
  t := Series::series(f, x, n, dir, opt);

  if domtype(t) = Series::Puiseux then
    d := ldegree(t);
    if d = FAIL then
      Series::error("order too small")
    elif d >= 0 then // expansion around a finite point 
      l := coeff(t, x, 0);
      if domtype(Re(l) - 1/2) <> DOM_INT and domtype(Im(l) - 1/2) <> DOM_INT then
        l := round(l);
        if domtype(Re(l)) = DOM_INT and domtype(Im(l)) = DOM_INT then
          return(Series::Puiseux::const(l, x, n, dir)) // l + O(x^n)
        end_if
      else
        userinfo(1,
          "no series expansion of round(x) around discontinuity x = "
          . expr2text(l));
        return(FAIL);
      end_if
    else // ldegree(t) < 0
      // use round(f) = f + 1/2 - frac(f+1/2)
      return(t + 1/2 - Series::Puiseux::const(frac(f+1/2), x, n, dir))
    end_if
  end_if;

  Series::unknown(round(f),x,n,dir)

end_proc:
