//    

/*--
	sinh/Series -- the function attribut "series" for sinh
--*/

sinh::series :=
proc(f,x,n,dir, opt)
   local t,k,a;
begin   
   if f=x then
      Series::Puiseux::create(1,1,2*((n+1) div 2)+1,Series::gen["sinh"](n),x,0,dir)
   else
      t:=Series::series(f,x,n,dir, opt);
      if domtype(t)<>Series::Puiseux then
         return(FAIL)
      end_if;
      k:=ldegree(t);
      if k=FAIL then // t = O(..)
	 k:=Series::Puiseux::order(t);
         if k > 0 then
            return(t)
         else
	    Series::error("order too small");
         end_if
      elif k>0 then
         Series::Puiseux::_fconcat(
            Series::Puiseux::create(1,1,2*((n+1) div 2)+1,Series::gen["sinh"](n),x,0,dir)
         ,t)
      elif k=0 then
         a:=lcoeff(t);
         t:=f-a;
         // sinh(a+t)=sinh(a)*cosh(t)+cosh(a)*sinh(t) 
         if iszero(sinh(a)) then
           cosh(a)*sinh::series(t,x,n,dir, opt)
         else
           sinh(a)*cosh::series(t,x,n,dir, opt)+
           cosh(a)*sinh::series(t,x,n,dir, opt)
         end_if
      else // expansion around infinity
         Series::series((exp(f) - exp(-f))/2, x, n, dir, opt)
      end_if
   end_if
end_proc:

// ensure that domain Series is loaded
Series:

Series::gen["sinh"]:=proc(n) local i,t; // 0.9s pour n=100 
begin
   t:=1;
   [1,(0,(t:=t/(2*i)/(2*i+1)))$i=1..(n-1) div 2]
end_proc:
Series::gen["sinh"](0):=[]:
Series::gen["sinh"](1):=[1]:

// end of file 
