/*	andIn.mu
 *	31.10.2004, rensmann
 *
 *	Checks if there are terms like ( x in A ) and ( x in B ) and simplifies
 *	to x in (A intersect B).
 *	Also recognizes simple equalities like (IDENT=Constant).
 *
 *	Returns false if there are excluding properties.
 */

Simplify::andIn := proc( a:"_and" )
	local inList, remainderList, i, sec;
begin
	inList := table(); remainderList := null();
	sec := proc( a,b )
	begin
		if ( contains( inList, a) ) then
			inList[ a ] := inList[ a ] intersect b
            else
			inList[ a ] := b;
		end_if;
      end;

	for i in a do
         if ( type( i ) = "_in" )and( type( op(i,1) ) = DOM_IDENT ) then
           sec( op(i,1), op(i,2) )
         else
	     remainderList := remainderList, i
         end_if
	end_for;

	return( _and( op( map( [op(inList)], X->op(X,1) in op(X,2) ) ) ) and remainderList );
end_proc;
