
Simplify::cancel_and:=
proc(A: "_and")
  local opsets, i;
begin
  opsets:= map([op(A)], x -> if type(x) = "_or" then {op(x)} else {x} end_if);
  opsets:= sort(opsets, (x, y) -> nops(x) >= nops(y));
  // now A = _and(_or(op(opsets,i)) $i=1..nops(opsets))
  // we may replace x and (x or y) by x
  // since we have sorted, we know that we have a chance to simplify
  // operands[i] and operands[j] -> operands[j] only if i < j
  i:= 1;
  while i <= nops(opsets) - 1 do
    if contains(
      map([op(opsets, i+1 .. nops(opsets))], _minus, opsets[i]),
        {}) > 0 then
      delete opsets[i]
    else
      i:= i+1
    end_if
  end_while;
  _and(_or(op(op(opsets,i))) $i=1..nops(opsets))

end_proc: