// 

// 06/2003, bij, stefanw
//

Simplify::combineConstantWithRoots:=
 proc(e: "_mult")
   local constant, num, den, expo, base, d,
   other: DOM_LIST,
   i: DOM_INT;
 begin

   constant:= op(e, nops(e));
   other:= [op(e, 1..nops(e) - 1)];
    
   case domtype(constant)
     of DOM_INT do
       den:= 1;
       num:= constant;
       break
     of DOM_RAT do
       [num, den]:= [op(constant)];
       break
     of DOM_COMPLEX do
       if map({op(constant)}, type) minus {DOM_INT, DOM_RAT} = {} then
         // extract common factors of real and imaginary part
         // we compute gcd(op(e,1), op(e, 2)) "by hand", avoiding a gcd call
         num:= igcd(numer(op(constant, 1)), numer(op(constant, 2)));
         if op(constant, 1) = 0 then
           den:= denom(op(constant, 2))
         else
           den:= ilcm(denom(op(constant, 1)), denom(op(constant, 2)))
         end_if;
         other:= append(other, constant/ (num/den));
         constant:= num/den;
         break
       else
         return(e)
       end_if
     otherwise
       return(e)
   end_case;


  
   for i from 1 to nops(other) do
     if type(other[i]) = "_power" and
       type((expo:= op(other[i], 2))) = DOM_RAT then

       case domtype((base:= op(other[i], 1)))
         of DOM_INT do

           // let den = d*a, base = d*b; then
           // (num/den) * base^(expo) = (num/a) * b^expo * d^(expo - 1)
           // = constant * d * (base/d)^expo * d^(expo - 1)
           d:= igcd(base, den);
           if d<>1 then
             constant:= constant * d;
             den:= den/d;
             other[i]:= subsop(other[i], 1 = base/d);
             other:= append(other, d^(expo-1));
              /* since num and den cannot have a common divisor,
                 we may stop here */
             break
           end_if;
           
            // let num = d*a, base = d*b; then
            // (num/den) * base^(expo) = (a/den) * b^expo * d^(expo + 1)
            // = constant / d * (base/d)^expo * d^(expo + 1)
           d:= igcd(base, num);
           if d<>1 then
             constant:= constant / d;
             num:= num/d;
             other[i]:= subsop(other[i], 1 = base/d);
             other:= append(other, d^(expo + 1))
           end_if;
           break
       end_case;

        
     end_if;
        
   end_for;

   return(_mult(op(other)) * constant )
    
 end_proc: