/*	consensus_and.mu
 *	12.10.2004 rensmann
 *
 *	Sucht minale Allgemeinkonsensusse und entfernt Redundante Terme.
 *	Beispiel:
 *	( a or b or not c ) and ( a or b or c ) = ( a or b )
*/

Simplify::consensus_and := proc( A: "_and" )
	local opsets, X, i, j;
begin
	opsets:= map([op(A)], x -> if type(x) = "_or" then {op(x)} else {x} end_if);
	opsets:= sort( opsets, (x, y) -> nops(x) >= nops(y) );

	i := 1;
	while i < nops( opsets ) do
		j := i + 1;
		while j <= nops( opsets ) and nops( opsets[i] )>1 and nops( opsets[i] )=nops( opsets[j] ) do
			X := opsets[i] intersect opsets[j];
			if ( nops(X)=nops(opsets[i])-1 and op( opsets[i] minus X ) = _not( op( opsets[j] minus X ) ) ) then
				opsets[i] := X;
				delete opsets[j]
			else
				j := j + 1;
			end_if;
		end_while;
		i := i + 1;
	end_while;

	_and( _or( op(op(opsets,i)) ) $i=1..nops(opsets) )
end_proc;
