

// turn (A_1 or A_2 or ...) and (B_1 or B_2 or ...) and ...
// into A_1 and B_1 and ...or A_2 and B_2 and ... or ...

Simplify::distribute_and:=
proc(a: "_and")
  local i, j, results;
begin
  results:= [TRUE];
  // at any time, results is a list of _and - expressions such
  // that _and(op(a, 1..i)) is equivalent to _or(op(results))

  for i from 1 to nops(a) do
    if type(op(a, i)) <> "_or" then
      results:= map(results, _and, op(a, i))
    else
      results:= _concat(map(results, _and, op(a, [i, j])) $j=1..nops(op(a, i)))
    end_if
  end_for;

  _or(op(results))
end_proc: