

// turn (A_1 and A_2 and ...) or (B_1 and B_2 and ...) or ...
// into A_1 or B_1 or ...and A_2 or B_2 or ... and ...

Simplify::distribute_or:=
proc(a: "_or")
  local i, j, results;
begin
  results:= [FALSE];
  // at any time, results is a list of _or - expressions such
  // that _or(op(a, 1..i)) is equivalent to _and(op(results))

  for i from 1 to nops(a) do
    if type(op(a, i)) <> "_and" then
      results:= map(results, _or, op(a, i))
    else
      results:= _concat(map(results, _or, op(a, [i, j])) $j=1..nops(op(a, i)))
    end_if
  end_for;

  _and(op(results))
end_proc: