/*
   Simplify::expand(a, options)

   expand a with the given options and additionally MaxExponent = 63
*/

Simplify::expand:=
proc(a)
begin
  if stdlib::hasfloat(a) then
    return(float(Simplify::expand(numeric::rationalize(a), args(2..args(0)))))
  end_if;    

  if simplify::expandComplexity(a) < 100000 then
    expand(a, MaxExponent = 63, args(2..args(0))) 
  else
    a
  end_if
end_proc: