
Simplify::factorEqualUnequal:=
proc(eq)
  local lhs, l, i;
begin
  assert(type(eq) = "_equal" or type(eq) = "_unequal");
  lhs:= op(eq, 1) - op(eq, 2);
  // now eq is equivalent to lhs=0 (or lhs <> 0, resp. )
  l:= coerce(maprat(lhs, factor), DOM_LIST);

  // special case
  if nops(l) = 1 then
    return(op(eq, 0)(l[1], 0))
  end_if;

  
  // suppose we are dealing with an equality. Then
  // a_1^(n_1) * ... * a_n^(n_m) = 0 iff at least one a_i with positive
  // exponent n_i is zero
  // if we are dealing with an inequality, all a_i must be nonzero

  case type(eq)
    of "_unequal" do
      _and((op(l, 2*i) <> 0) $i=1..nops(l) div 2);
      break
    of "_equal" do
      _or((if l[2*i+1] > 0 then
            l[2*i] = 0
          end_if)
           $i=1..nops(l) div 2);
      break
  end_case

end_proc: