// 

// 06/2003, bij, stefanw
//

// simplify powers with integer base

Simplify::intBase:=
proc(e: "_power")
  local a, b, p, q, br, l, i;
begin
  [a, b]:= [op(e)];

  if domtype(a) <> DOM_INT then
    return(e)
  end_if;




  if (q:= numlib::ispower(a)) <> FALSE then
    b:= b*op(q, 2);
    a:= op(q, 1);
    if type(b) = DOM_INT then
      return(a^b)
    end_if
  end_if;
    
  
  
  if type(b) = DOM_RAT then
    if a < 0 then
      return( (-1)^b * (-a)^b )
    end_if;
    


     // extract factors of the form n^q

    q:=denom(b);
    p:=numer(b);
    l:=stdlib::ifactor(a, UsePrimeTab);
     // l[1] is known to be 1, since a is positive
     // get all pairs l[2*i],l[2*i+1] according to whether
     // q >= l[2*i+1]

    br:=1;
     // loop invariant is a^(p/q) * br
    for i from 2 to nops(l) step 2 do
      if l[i+1] >= q then
         // if l[i+1]= s*q +t, the power (l[i]^l[i+1])^(p/q) can be simplified
         // to l[i]^(ps) * l[i]^(pt/q)
         // divide a by l[i]^s
        a := a / l[i]^ (q*(l[i+1] div q));
        br:= br* l[i] ^ (p*(l[i+1] div q))
      end_if
    end_for;
    return(a^(p/q)*br)
  end_if;

  e
end_proc: