
Simplify::minus1Power:=
proc(a: "_power")
  local expo, reduceMod2: DOM_PROC;
begin
  assert(op(a, 1) = -1);
  expo:= op(a, 2);

  // Some special case: If we got (-1)^(b^n) with 'b' an integer and n >= 0:
  //   Then we have: (-1)^(b^n) = (-1)^b
  if type(expo) = "_power" and is(op(expo, 1) in Z_) = TRUE and
    is(op(expo, 2), Type::NonNegative) = TRUE  then
    return((-1)^op(expo, 1))
  end_if;

  // symmetric reduction modulo 2
  reduceMod2:=
  proc(b)
    local C, Cred, bb;
  begin
    case type(b)
      of DOM_INT do
        return(b mod 2)
      of DOM_RAT do
        return(frac(1/2 + b/2)*2 - 1)
      of DOM_COMPLEX do
        return(reduceMod2(op(b, 1)) + op(b, 2)*I)
      of "_plus" do
        return(map(b, reduceMod2))
      of "_mult" do
        C:= op(b, nops(b));
        if ((Cred:= reduceMod2(C))) <> C and
          is((bb:= subsop(b, nops(b) = 1)), Type::Integer) = TRUE then
          return(reduceMod2(Cred*bb))
        end_if;
        break
    end_case;
    if is(b, Type::Even) = TRUE then
      return(0)
    end_if;
    if is(b, Type::Odd) = TRUE then
      return(1)
    end_if;
    if is(b, Type::Integer)=TRUE and stdlib::hasmsign(b) then
      -b
    else
      b
    end_if
  end_proc;

  expo:= reduceMod2(expo);

  if type(expo) = DOM_RAT and expo<0 then
    return(- (-1)^(expo+1))
  else
    return((-1)^expo)
  end_if

end_proc: