/*	orIn.mu
 *	03.05.2005, rensmann
 *
 *	Checks if there are terms like ( x in A ) or ( x in B ) and simplifies
 *	to x in (A union B).
 *	Also recognizes simple equalities like (IDENT=Constant).
 */

Simplify::orIn := proc( a:"_or" )
      local inList, remainderList, i, sec;
begin
      inList := table(); 
      remainderList := null();
      sec := proc( a,b )
      begin
            if ( contains( inList, a) ) then
                  inList[ a ] := inList[ a ] union b;
            else
                  inList[ a ] := b;
            end_if;
      end_proc;

      for i in a do
            if ( type( i ) = "_in" )and( type( op(i,1) ) = DOM_IDENT ) then
                  sec( op(i,1), op(i,2) )
            elif (type( i ) = "_equal")and(type(op(i,1)) = DOM_IDENT )and(testtype(op(i,2),Type::Constant)) then
                  sec( op(i,1), {op(i,2)})
            else
                  remainderList := remainderList, i;
            end_if;
      end_for;

      return( _or( op( map( [op(inList)], X->op(X,1) in op(X,2) ) ) ) or remainderList )
end_proc;
