/*	resolution_or.mu
 *	19.10.2004 rensmann
 *
 *	Entfernt redundante Klauseln nach folgendem Schema:
 *	Steht im Term eine Klausel der Form ( x and A ) or ( not x and B ) or ( A and B )
 *	dann ist die letzte Klausel redundant und kann entfernt werden.
 *	Ausserdem werden Terme der Form ( x ) or ( not x and A ) auf ( x ) or ( A ) vereinfacht.
*/

Simplify::resolution_or:=proc( A: "_or" )
	local opsets, i, j, k, cut, negation, red;
begin
	opsets:= map([op(A)], x -> if type(x) = "_and" then {op(x)} else {x} end_if);
	// now A = _and(_or(op(opsets,i)) $i=1..nops(opsets))
	i:= 1;

	// loop for every term
	while i <= nops(opsets) - 1 do
		negation := map( opsets[i], _not );
		j := i+1;

		// check if there is a literal in one term that appears negatived in an other term
		while j <= nops( opsets ) do
			cut := opsets[j] intersect negation;
			if nops(cut)=1 then
				if nops( opsets[i] )=1 then
					opsets[j] := opsets[j] minus cut;
				else
					red := ( opsets[j] minus cut ) union ( opsets[i] minus map( cut, _not ) );
					k := 1;
					// check if the redundant term appears in the expression
					while k <= nops( opsets ) do
						if ( k<>i and k<>j and red subset opsets[k] ) then
							// we got one, remove it
							delete opsets[k];
							if ( k<=i ) then i := i-1; end_if;
							if ( k<=j ) then j := j-1; end_if;
						else
							k := k+1;
						end_if:
					end_while;
				end_if;
			end_if;
			j := j+1;
		end_while;
		i:= i+1;
	end_while;
	_or(_and(op(op(opsets,i))) $i=1..nops(opsets))
end_proc:
