
// x = sign(x) * abs(x), so sign(x) = x / abs(x) 

Simplify::signToAbsInProd:=
proc(a: "_mult")
  local ops, signs, x, i, hasfactor;
begin
  hasfactor:= 
  proc(l, f)
    local i;
  begin
    _lazy_or
    (
     (l[i] = f or 
     type(l[i]) = "_power" and op(l[i], 1) = f and is(op(l[i], 2) >= 1, Goal = TRUE)) 
     $i=1..nops(l)
     )    
  end_proc;

  ops:= [op(a)];
  [signs, ops, x]:= split([op(a)], testtype, "sign");
  // now signs = all signs; ops = all other operands
  for i from 1 to nops(signs) do
    x:= op(signs[i], 1);
    if is( x in R_, Goal = TRUE) and 
      (is(x<>0, Goal = TRUE) or hasfactor(ops, x) )  then 
      a := a / signs[i] / x * abs(x)
    else
      if is(x <> 0, Goal = TRUE) or subs(denom(a), x=0, EvalChanges) = 0 then
        a:= a / signs[i] / abs(x) * x 
      end_if;
    end_if
  end_for;

  a
end_proc:
// end of file
