
Simplify::Global:=
proc(EXPR)
local inds;

begin
if EXPR::dom::Simplify <> FAIL then
  // only do overloading
  return([])
end_if;

  
inds:= indets(EXPR, All);
// global rewrite - Rules

[
if inds intersect {hold(arctan), hold(log)} <> {} then
  Rule(X -> rewrite(X, ln), {}, table("Default" = 0.93))
else
  null()
end_if,

 if nops(inds intersect {hold(sin), hold(cos), hold(tan), hold(cot),
                         hold(sinh),hold(cosh),hold(tanh),hold(coth)}) > 1 then
   Rule(X -> simplify::trighyp(X), {}, table("Default" = 0.95))
 end_if,

 if inds intersect {hold(sin), hold(cos), hold(sinh), hold(cosh)} <> {}
   then
   Rule(X -> rewrite(X, exp), {}, table("Default" = 0.95))
 else
	 if inds intersect {hold(_power) } <> {}
	   then
	   Rule(X -> rewrite(X, exp), {}, table("Default" = 1.55))
	 else
	   null()
	 end_if
 end_if,

 if inds intersect {hold(tan), hold(cot)} <> {} then
   Rule(X -> rewrite(X, sincos), {}, table("Default" = 1.95))
 else
   null()
 end_if,

 if inds intersect {hold(exp)} <> {} then
   Rule(Simplify::rewriteTrig, {}, table("Default" = 1.2))
 else
   null()
 end_if,

 if inds intersect {hold(cos)} <> {} then
   Rule(X -> rewrite(X, sin), {}, table("Default" = 0.95))
 else
   null()
 end_if,

 if inds intersect {hold(sin)} <> {} then
   Rule(X -> rewrite(X, cos), {}, table("Default" = 0.95))
 else
   null()
 end_if,

 if inds intersect {hold(cos), hold(sin)} <> {} then
   Rule(X -> rewrite(X, tan), {}, table("Default" = 1.3))
 else
   null()
 end_if,

 if inds intersect {hold(tan)} <> {} then
   Rule(X -> rewrite(X, cot), {}, table("Default" = 1.3))
 else
   null()
 end_if,
 
 if inds intersect {hold(sinh)} <> {} then
   Rule(X -> rewrite(X, cosh), {}, table("Default" = 1.1))
 else
   null()
 end_if,

 if inds intersect {hold(cosh)} <> {} then
   Rule(X -> rewrite(X, sinh), {}, table( "Default" = 1.24 ))
 else
   null()
 end_if,

 if inds intersect {hold(sinh), hold(cosh)} <> {} then
   Rule(X -> rewrite(X, tanh), {}, table( "Default" = 1.5 ))
 else
   null()
 end_if,

 if contains(inds, hold(besselJ)) then
    if inds intersect {hold(besselI), hold(besselY), hold(besselK)} <> {} then
       Rule(X -> simplify::besselJ(X), {}, table( "Default" = 1.0));
    end_if:
 elif contains(inds, hold(besselI)) then
    if inds intersect {hold(besselY), hold(besselK)} <> {} then
       Rule(X -> simplify::besselI(X), {}, table( "Default" = 1.0));
    end_if:
 elif contains(inds, hold(besselY)) then
    if inds intersect {hold(besselK)} <> {} then
       Rule(X -> simplify::besselJ(X), {}, table( "Default" = 1.0));
    end_if:
 end_if,

 if contains(inds, hold(wrightOmega)) then
    Rule(X -> rewrite(X, lambertW))
 end_if,

 if property::hasprop(EXPR) then
   Rule(property::normalGroebner)
 end_if,
 
 if hastype(EXPR, unit) then
   Rule(unit::simplify, {}, table("Default" = 0.7))
 else
   null()
 end_if
   
 ]

end_proc:
