// 

// 06/2003, bij, stefanw
//
// simplification methods for expressions of type '_mult'
//   must be a list of procedures or rules

Simplify::_mult :=
proc(expression)
  local inds, types, ratinds, nexps, realindets, negpowers, powers, x,
  negpowinds;
begin
  if not testtype(expression, Type::Arithmetical) then 
    // this can happen - hold(_mult)(some_nonsense) or _mult(a[i] $i=1..n) for symbolic n
    return([])
  end_if;

  realindets := indets( expression );
  inds:= indets(expression, All);
  ratinds:= indets(expression, RatExpr);
  types:= map({op(expression)}, type);
  if contains(types, "_power") then
    powers:= select({op(expression)}, a-> type(a) = "_power");
    negpowers:= select(powers,
                       a -> _lazy_and(type(op(a, 2)) = DOM_INT, op(a, 2) < 0));
    negpowinds:= indets(negpowers, RatExpr)
  end_if;
  nexps := nops(select(ratinds, testtype, "exp")):

  [
   if contains(types, "_power") then
     if nops(select([op(expression)], fctor->( type(fctor) = "_power" and
            type(op(fctor, 1)) = DOM_INT or type(fctor) = DOM_INT) ) )>1 and contains(types, DOM_INT ) then
       Rule(Simplify::combineIntPowers)
     end_if,
     if ( contains( { DOM_RAT, DOM_COMPLEX, DOM_INT }, domtype( op( expression, nops(expression) ) ) ) ) then
       Rule(Simplify::combineConstantWithRoots)
     end_if,
     if nops(negpowers) > 0 then
       ((Rule(fp::unapply(hold(Simplify::divide)(`#X`, 1/_mult(op(negpowers)),
                                                 x), `#X`), {},
              table("Default" = 0.98))
        $x in negpowinds)),
       ((Rule(fp::unapply(hold(partfrac)(`#X`, x, Mapcoeffs = expr@(polylib::sqrfree)@normal), `#X`), {},
              table("Default" = 1.2^nops(negpowinds)))
         $x in negpowinds))
     end_if
   end_if,
   
   
   if nops(select(misc::subExpressions(expression, {"_power"}), X -> type(op(X, 2)) = DOM_RAT)) <> 0 then 
     Rule(Simplify::fractionalPowers, {}, table("Default" = 0.95))
   end_if,
   
   
   // shallow expanding
   if contains(types, "_plus") then
     Rule(_mult::shallowExpand, {}, table("Default" = .85))
   end_if,
   
   // if option IgnoreAnalyticConstraints is used, this has low priority as we already call _mult::combine(..., IgnoreAnalyticConstraints)
   Rule(_mult::combine, {}, table("Default" = .92,
                                  "IgnoreAnalyticConstraints" = 3.0)),
   
   (if inds intersect {hold(sin), hold(cos)} <> {} then
      Rule( Simplify::combineSinCos, {}, table( "Default"=0.9 ) )
    elif nexps>1 then
      Rule(X -> combine(X, exp))
    elif contains(inds, hold(ln)) then
      Rule(X -> combine(X, ln))
    end_if),

    if inds intersect {hold(tan), hold(cot)} <> {} then
      Rule(X -> normal(rewrite(X, sincos)))
    end_if,

    // the following rule is useful e.g. to achieve sinh/cosh = tanh
    if inds intersect {hold(sinh), hold(cosh), hold(tanh)} <> {} then
      Rule(X->normal(rewrite(X, exp)))
    end_if,
   
   if contains(types, "tan") then
     Rule(tan(`#a`)*tan(`#b`), (cos(`#a`-`#b`)-cos(`#a`+`#b`))/(cos(`#a`-`#b`)+cos(`#a`+`#b`))),
     Rule(tan(`#a`)*cot(`#b`), (sin(`#a`-`#b`)+sin(`#a`+`#b`))/(sin(`#a`+`#b`)-sin(`#a`-`#b`))),
     Rule(X -> rewrite(X, cot), {}, table("Default" = 1.2))
   end_if,


   if contains(types, "dirac") then
     Rule(simplify::dirac, {}, table("Default" = 0.1))
   end_if,
   
   if contains(types, "gamma") then
     Rule(simplify::gamma, {}, table("Default" = 0.1))
   end_if,
   
   if contains(types, "sign") then
     // replace sign by abs
     Rule(Simplify::signToAbsInProd, {}, table("Default" = 1.1)),
     (if contains(types, "abs") then
        Rule(Simplify::collectAbsSign)
      end_if)
    end_if,

    if contains(types, "conjugate") then
        Rule(simplify::conjugate)
    end_if
   ]
end_proc:

_mult::shallowExpand :=
proc(e)
  local i, p;
begin
  assert(type(e)="_mult");
  for i from 1 to nops(e) do
    if type(op(e, i))="_plus" then
      e := _plus(subsop(e, i=p) $ p in op(e, i));
      break;
    end_if;
  end_for;
  e;
end: