// 

// 06/2003, bij, stefanw
//
// simplification methods for expressions of type '_power'


Simplify::_power :=
proc(expression: "_power"): DOM_LIST
  local bas, expo;
begin
  assert(nops(expression) = 2);
  [bas, expo]:= [op(expression)];

  if bas = 0 then
    return([Rule(Simplify::zeroPower, {}, table("Default" = 0.1))])
  end_if;

  if bas = - 1 then
    return([Rule(Simplify::minus1Power, {}, table( "Default" = 0.95) )])
  end_if;

  [
   

   case type(bas)
     of DOM_COMPLEX do
       Rule(Simplify::IToMinus1);
       break
     of DOM_INT do
       Rule(Simplify::intBase, {}, table("Default" = 0.8)),
       if has(expo, hold(log)) then
          Rule(Simplify::intPowHasLog, {}, table("Default" = 0.02))
       end_if;
       break
     of "exp" do
       Rule(X -> combine(X, exp));
       break
     of "sign" do
       Rule(Simplify::signToAbsInPower);
       break
     of "abs" do
       if is(op(bas), Type::Real)=TRUE then
         Rule(Simplify::absInPower, {}, table("Default" = 0.8));
       end_if;
       break
     of "_power" do
       Rule(_power::combine);
       break
     otherwise
       null()
   end_case,

   case type(expo)
     of DOM_INT do
       case type(bas)
         of "sin" do
           // special case 1/sin^2 = 1 + cot^2
           if expo = -2 then
             Rule(X -> 1 + cot(op(X, [1, 1]))^2)
           else
             null()
           end_if,
            // do a local rewrite:
            // rewrite sin(X)^(2*n) as (1-cos(X)^2)^n
            // and     sin(X)^(2*n+1) as sin(X) * (1-cos(X)^2)^n
           if expo = 2 then
             Rule(X -> 1 - cos(op(X, [1, 1]))^2, {},
                  table("Default" = 0.8))
           else  
             Rule(X -> op(X, 1)^(op(X,2) mod 2) *
                  (1 - cos(op(X, [1, 1]))^2)^(op(X,2) div 2), {},
                  table("Default" = 0.98));
           end_if;
           break
         of "cos" do
           // special case 1/cos^2 = 1 + tan^2
           if expo = -2 then
             Rule(X -> 1 + tan(op(X, [1, 1]))^2)  
           end_if,
           if expo = 2 then
             Rule(X -> 1 - sin(op(X, [1, 1]))^2, {},
                  table("Default" = 0.8))
           else
             Rule(X -> op(X, 1)^(op(X,2) mod 2) *
                  (1 - sin(op(X, [1, 1]))^2)^(op(X,2) div 2), {},
                  table("Default" = 0.98))
           end_if;
           break
         of "tan" do
           // special case tan^2 = 1/cos^2 - 1
           if expo = 2 then
             Rule(X -> cos(op(X, [1, 1]))^(-2) - 1, {},
                  table("Default" = 0.8))
           end_if;
           break; 
         otherwise
           null()
       end_case;
       break

     of DOM_COMPLEX do
       // the following is our only chance to make (x+1)^(2+I) into (x^2 + 2*x +1) * (x+1)^I
       Rule(X -> expand(op(X, 1)^Re(op(X, 2))) * op(X, 1)^(I*Im(op(X, 2))));
      break

     of DOM_RAT do
       Rule(Simplify::ratExponent);
       break
     otherwise
       // will only help if the exponent has the property Type::Even
       // done by the kernel if the exponent is a DOM_INT
       Rule(Simplify::normalizesignBase, {}, table("Default" = 1.05)),
       Rule(X -> if is(op(X, 1)<>0) = TRUE then
                   exp(op(X,2)*ln(op(X, 1)))
                 else
                   X
                 end_if
            )
   end_case,

   if type(expo) = "log" and op(expo, 1) = bas then
     Rule(Simplify::expPowLog, {}, table("Default" = 0.01))
   end_if,

	if testtype( op(expression,1), "_mult" ) then
		Rule(Simplify::distributeExponent, {}, table("Default" = 0.8))
	end_if,

   if domtype(bas) <> DOM_INT and domtype(bas) <> DOM_RAT then
     Rule(Simplify::extractContentFromBase, {}, table("Default" = 0.8))
   end_if,

	//           1            a - b
	// rewrite -----  to   -----------
	//         a + b        a^2 - b^2
	if expo=-1 and testtype( bas, "_plus" ) and nops(bas)=2 then
		if nops( select( op(bas), X->( type(X) in { DOM_COMPLEX, DOM_RAT, DOM_INT } or ( testtype(X,"_power") and op(X,2)=1/2 ) ) ) )=2 then
			Rule( X->( ( op(X,[1,1])-op(X,[1,2]) ) / ( op(X,[1,1])^2-op(X,[1,2])^2 )  ), {}, table( "Default"=0.9 ) )
		end_if
	end_if,

   // Walter, May 2010: 
   // exp(I*arg(z)) now automatically rewrites itself to z/abs(z).
   // This make the following rule useless in those cases where
   // arg(z) comes back symbolically. It is still useful when
   // arg(z) returns with some explicit value:
   if is(expo, Type::Real) = TRUE then
     // try polar coordinates
     // z^x = |z|^x * exp(I*x*arg(z))
     Rule(`#X` -> abs(op(`#X`,1))^op(`#X`, 2) *
          exp(I*op(`#X`, 2)*arg(op(`#X`, 1)))
          )
   end_if,

   if expo=1/2 then
     Rule(Simplify::radsimpMatchSqrt),
     if is(bas < 0, Goal = TRUE) then
    	 Rule(#X -> I*(-op(#X, 1))^(1/2), {}, table("Default" = 0.95))
     end_if
   end_if,

   if expo = -1/2 then
     if is(bas < 0, Goal = TRUE) then
    	 Rule(#X -> -I/(-op(#X, 1))^(1/2), {}, table("Default" = 0.95))
     end_if     
   end_if,


   if expo=2 and type(bas) = "Re" then
     Rule(X-> abs(op(X, [1, 1]))^2 - Im(op(X, [1, 1]))^2)
   end_if

   //Rule(X -> rewrite(X, exp)),
   //Rule(proc(X)
   //       local fac;
   //     begin
   //       if domtype(op(X, 1)) = DOM_INT then
   //         fac := ifactor(op(X, 1));
   //         (op(fac, 1)*op(fac, 2))^(op(fac, 3)*op(X, 2))
   //       else
   //         FAIL
   //       end_if
   //     end_proc),
   ]
end_proc:
