// 

// 06/2003, bij, stefanw
//
// simplification methods for expressions of type 'ln'
//   must be a list of procedures or rules

Simplify::ln :=
proc(a: "ln")
  local x, rx, n;

begin
  x:= op(a);
  case type(x)

    of DOM_INT do
      [Rule(X -> Simplify::factorlnInt(X), {}, table("Default"=0.9))];
      break
    of DOM_COMPLEX do
      rx := [rationalize(x)];
      n := icontent(rx[1]);
      [
      if n<>1 then
         Rule(`#X`, ln(abs(n))+ln(x/abs(n)), {}, table("Default" = 0.8))
      end_if,
      Rule(X -> expr(rectform(X)), {}, table("Default" = 0.8))
      ];
      break
    otherwise
      rx := [rationalize(subs(x, I=`#I`))];
      n := icontent(rx[1]);
      if n=1 or n=FAIL then
        []
      else
        [Rule(`#X`, ln(abs(n))+ln(x/abs(n)), {}, table("Default" = 0.8))];
      end_if
  end_case
  

end_proc:
  
