
/*************************************************
Simplify::pairPenalty(a)

punishes every "inconsistent" pair of operators in a
e.g. sin should not occur together with tan, ln not together with log


*************************************************/


Simplify::pairPenaltyTable:=
table(
 {hold(sin), hold(tan)} = 200,
 {hold(cos), hold(tan)} = 200,
 {hold(cos), hold(cot)} = 200,
 {hold(sin), hold(cot)} = 200,
 {hold(tan), hold(cot)} = 300,
 {hold(log), hold(ln)} = 200,
 {hold(cosh), hold(exp)} = 300,
 {hold(sinh), hold(exp)} = 300    
 ):

Simplify::badPairs:= map([op(Simplify::pairPenaltyTable)], op, 1):

Simplify::pairPenalty:=
proc(a)
  local inds;
begin
  inds:= indets(a, All);
  _plus(op(map(select(Simplify::badPairs, _subset, inds),
               P -> Simplify::pairPenaltyTable[P])))
end_proc:
  