/*    */

// solvelib::BasicSet - the domain of basic sets



alias(Z = new(solvelib::BasicSet, Dom::Integer)):
alias(Q = new(solvelib::BasicSet, Dom::Rational)):
alias(R = new(solvelib::BasicSet, Dom::Real)):
alias(C = new(solvelib::BasicSet, Dom::Complex)):


alias(path = pathname("SOLVELIB", "BASICSET")):


domain solvelib::BasicSet

  local plusexpr, multexpr;

  inherits Dom::BaseDomain;

  category Cat::Set;

  axiom Ax::canonicalRep;
      /* no two basic sets represent the same mathematical object !? */


      /* entries */

    convert:=
    proc(x)

    begin
      if contains({Dom::Integer, Dom::Real, Dom::Rational, Dom::Complex}, x)
        then
        new(dom, x)
      else
        FAIL
      end_if
    end_proc;

    _subset :=
    proc( A, B )
      local r;
    begin
      assert(type(A) <> DOM_SET); // should have been handled in _subset
      case type(A)
        of dom do
          assert(type(B) <> dom); // should have been handled by assignment
          case type(B)
            of Dom::Interval do
            of DOM_SET do
              return(FALSE)
          end_case;
          break
        of Dom::Interval do
          if B=R_ or B=C_ then
            return(TRUE)
          end_if;
          if is(A::dom::left(A) < A::dom::right(A)) = TRUE then
            return(FALSE)
          end_if;
          break
        of "_intersect" do
          r := map( {op(A)}, _subset, B );
          if contains( r, TRUE ) then return( TRUE ); end_if;
          break;
        of "_union" do
          r := map( {op(A)}, _subset, B );
          if contains( r, FALSE ) then return( FALSE ); end_if;
          break;
        of "_minus" do
          r := op(A,1) subset B;
          if ( r=TRUE) then return( TRUE ) end_if;
          break;

      end_case;

      hold(_subset)(A,B)
  end_proc;

    // overload Simplify::complexity
    complexity:=
    proc(S)
    begin
      10
    end_proc;
    

    /* equality */


  bin_equal:= bool@_equal;


  inhomog_equal:=
  table(
        DOM_SET = FALSE
        );


/* union, intersection, minus */

  homog_intersect:=
  proc()
    local arglist;

  begin
    arglist:=[args()];
    assert({op(arglist)} minus {Z, Q, R, C} = {});
    if contains(arglist, Z)>0 then
      Z
    elif contains(arglist, Q)>0 then
      Q
    elif contains(arglist, R)>0 then
      R
    else
      C
    end_if
  end_proc;


  homog_union:=
  proc()
    local arglist;

  begin
    arglist:=[args()];
    assert({op(arglist)} minus {Z, Q, R, C} = {});
    if contains(arglist, C)>0 then
      C
    elif contains(arglist, R)>0 then
      R
    elif contains(arglist, Q)>0 then
      Q
    else
      Z
    end_if
  end_proc;


  bin_minus:=
  proc(A: dom, B: dom)
  begin
    // should be controlled by the category
    assert(args(0) = 2);
    if A=B or B = C then
      {}
    else
      // some cases are also handled by assignment below !
      hold(_minus)(A, B)
    end_if
  end_proc;



  inhomog_intersect:=
  table(

        "DOM_EXPR"=
        proc(bset, e:DOM_EXPR)
          local A, B;
          save MAXEFFORT;
        begin
          if bset=C then
            e
          else
            if not testtype(e, Type::Set) then
              error("Argument of _intersect is not a set")
            end_if;
            case type(e)
              of "_minus" do
                if op(e, 1) = bset then 
                   // bset intersect (bset minus e2) = bset minus e2
                   return(e)
                end_if;
                MAXEFFORT:= MAXEFFORT/2;
                A:=bset intersect op(e,1);
                B:=bset intersect op(e,2);
                if type(A)<>"_intersect" and type(B)<>"_intersect" then
                  return(A minus B)
                end_if;
                if B=bset then return( {} ); end_if;
                break
              of "_union" do
                MAXEFFORT:= MAXEFFORT/nops(e);
                A:=map([op(e)], _intersect, bset);
                if contains(map(A, type), "_intersect")=0 then
                  return(_union(op(A)))
                end_if;
                break
              of "Union" do
                MAXEFFORT:= MAXEFFORT/2;
                A:= op(e, 1) intersect bset;
                if type(A) <> "_intersect" then
                  return(solvelib::Union(A, op(e, 2..nops(e))))
                end_if;
                break
              of "solve" do
                if type(op(e, 2)) <> DOM_IDENT then
                  break
                end_if;
                MAXEFFORT:= MAXEFFORT/2;
                assume(op(e, 2) in bset);
                if traperror((A:= eval(op(e, 1)))) <> 0 then
                   // if x is in bset, then op(e, 1) is undefined 
                   // hence there is no solution in bset
                   return({})
                end_if;
                if A <> op(e, 1) then
                  return(solve(A, op(e, 2..nops(e))))
                end_if;
                break
            end_case;
            FAIL
          end_if
        end_proc,

        "DOM_SET"=
        proc(bset, S:DOM_SET)
          local splitset;
        begin
          if bset=C then
            return(S)
          end_if;
          splitset:=split(S, is,(case bset
                                   of Z_ do
                                     Type::Integer;
                                     break;
                                   of Q_ do
                                     Type::Rational;
                                     break
                                   of R_ do
                                     Type::Real;
                                     break
                                 end_case));
          if op(splitset,3)={} then
            splitset[1]
          else
            // expand each element of splitset[3] to a piecewise
            map(splitset[3], el-> piecewise([el in bset, {el}],
                                            [not el in bset, {}]));
            splitset[1] union _union(op(%))
          end_if
        end_proc,

        "Dom::Multiset" =
        proc(bset, S:Dom::Multiset)
          local splitset;
        begin
         if bset=C then
            return(S)
          end_if;
          splitset:=split(S, is,(case bset
                                   of Z_ do
                                     Type::Integer;
                                     break;
                                   of Q_ do
                                     Type::Rational;
                                     break
                                   of R_ do
                                     Type::Real;
                                     break
                                 end_case));
          if nops(splitset[3])=0 then
            splitset[1]
          else
            splitset[1] union hold(_intersect)(splitset[3], bset)
          end_if
        end_proc,


        "Dom::Interval" =
        proc(bset,iv)
          local lb, rb,
          myfloor: DOM_PROC,
          myceil: DOM_PROC;
          
        begin

          myceil:=
          proc(x)
            local hx, i;
            save DIGITS;
          begin
            if contains({DOM_INT, "ceil", "floor"}, type(x)) then
              return(x)
            end_if;
            for i from 1 to 2 do
              hx:= [op(hull(x))];
              if type(hx[1]) = DOM_INTERVAL then
                hx:= [op(hx[1])]
              end_if;
              if has(hx, {RD_INF, RD_NINF}) then
                return(hold(ceil)(x))
              end_if;
              hx:= map([op(hx)], ceil);
              if hx[1] = hx[2] then
                return(hx[1])
              end_if;
              if i=1 then
                // increase precision
                DIGITS:= DIGITS + ceil(ln((hx[2] - hx[1]))/ln(10))
              end_if;
            end_for;

            // even with higher precision, we have a difference
            if hx[2] - hx[1] = 1 then
              // we still have a chance
              if numeric::isless(-x, -hx[1]) = TRUE then
                return(hx[2])
              else
                return(hx[1])
              end_if
            end_if;

            hold(ceil)(x)
        
          end_proc;

          myfloor:=
          proc(x)
            local res;
          begin
            res:= -myceil(-x);
            if type(res) <> DOM_INT then
              hold(floor)(x)
            else
              res
            end_if
          end_proc;

          
          if bset=R or bset=C then
            iv
          elif bset=Q then
            FAIL
          else /* bset = Z */
            if testtype((lb:=iv::dom::left(iv)), Type::Constant)=TRUE and
              lb<>RD_NINF then
              if not iv::dom::isleftopen(iv) then
                lb:=[myceil(lb)];
              else
                lb:=[myfloor(lb+1)];
              end_if;
              if has(lb, {hold(ceil), hold(floor)}) then
                lb:= iv::dom::leftB(iv)
              end_if;
            else
              lb := iv::dom::leftB(iv)
            end_if;
            if testtype((rb:=iv::dom::right(iv)), Type::Constant)=TRUE and
              rb<>RD_INF then
              if not iv::dom::isrightopen(iv) then
                rb:=[myfloor(rb)];
              else
                rb:=[myceil(rb-1)];
              end_if;
              if has(rb, {hold(ceil), hold(floor)}) then
                rb:= iv::dom::rightB(iv)
              end_if;
            else
              rb := iv::dom::rightB(iv)
            end_if;
            if lb<>iv::dom::leftB(iv) or rb<>iv::dom::rightB(iv) then
              iv := Dom::Interval( lb, rb );
              if type(iv)<>Dom::Interval then
                return( iv intersect Z_ )
              end_if;
            end_if;

            if type((lb:=iv::dom::left(iv))) = DOM_INT and
              type((rb:=iv::dom::right(iv))) = DOM_INT and
              rb - lb < 1000 then
                {$lb..rb}
            else
              hold(_intersect)(Z_, iv)
            end_if
          end_if
        end_proc,

        "Dom::ImageSet"=
        proc(bset, iset)
          local x, S, sol, rform, setlist, varlist, i;
          save MAXEFFORT;
        begin
          if bset=C then
            return(iset)
          end_if;

          // test for special case: Z_ intersect a + b*Z_
          if bset=Z and iset::dom::isisetLinear(iset)<>FALSE and iset::dom::sets(iset)=[Z_] then
            S := ( iset::dom::linZ_intersect( Z_, iset ) );
            if not testtype( S, "_intersect" ) then return( S ); end_if;
          end_if;

          if bset<>R then
            // we proceed in two steps:
            // intersect with R_, then find out rationals/integers
            // if possible
            MAXEFFORT:= MAXEFFORT/2;
            S:= R intersect iset;
            if type(S) = DOM_SET then
              return(bset intersect S)
            else
              return(FAIL)
            end_if;
           end_if;

        assert(bset = R);

        /* call ImageSets own function to reduce iset to a simpler form */
        iset := iset::dom::intersectR_( iset );
        if not testtype( iset, Dom::ImageSet ) then return( iset intersect bset ); end_if;

        varlist:= iset::dom::variables(iset);
          if nops(varlist) <> 1 then
            // handle only one simple case
            setlist:= iset::dom::sets(iset);
            // should not happen, but we test it anyway
            if contains(setlist, {}) > 0 then
              return({})
            end_if;

            for i from 1 to nops(varlist) do
                assume(varlist[i] in setlist[i])
            end_for;
            rform:= rectform(expr(iset));
            if op(rform, 3) = 0 then
              if nops((S:= indets(op(rform, 2)) intersect
                       {op(varlist)})) = 1 then
                x:= op(S);
                i:= contains(varlist, x);
                setlist[i]:= solve(op(rform, 2), x) intersect setlist[i];
                return(Dom::ImageSet(op(rform, 1), varlist, setlist))
              end_if;
            end_if;
            // cannot solve for more than one var
            return( hold(_intersect)( iset, R_ ) );
          end_if;
          x := iset::dom::variables(iset)[1];
          S:= iset::dom::sets(iset)[1];
        // should not happen:
        if S = {} then
          return({})
        end_if;
          // re - attach the properties to x
        unassume(x);
        assumeAlso(x in S);
        MAXEFFORT:= MAXEFFORT/2;
        sol:= solvelib::preImage(expr(iset) , x, R_);
        if has(sol, hold(solve)) or type(sol)=Dom::ImageSet or type(sol) = "_intersect" then
          // avoid infinite recursion
          return(FAIL)
        else
          sol:= solvelib::solve_intersect(sol, S)
        end_if;
        solvelib::substituteBySet(expr(iset), x, sol)
        end_proc,

        "RootOf" =
        proc(bset, rof)
        begin
          case bset
            of C_ do
              return(rof)
            of R_ do
            of Q_ do
            of Z_ do
              if freeIndets(rof) = {} and degree(op(rof, 1), [op(rof, 2)]) < Pref::autoExpansionLimit() and
                map({coeff(op(rof, 1), [op(rof, 2)])}, type) minus {DOM_INT, DOM_RAT} = {}
                then
                //solve this numerically
                if polylib::realroots(op(rof, 1), 1.0) = [] then
                  return({})
                end_if
              end_if;
              break;
          end_case;
        FAIL
        end_proc,

        "stdlib::Universe" =
        proc(bset, U)
        begin
          bset
        end_proc,

        "piecewise"= proc() begin piecewise::_intersect(args()); end_proc

          );

  inhomog_union:=
  table(

        "DOM_EXPR"=
        proc(bset, e)
        begin
          if bset=C then
            return(bset)
          end_if;
          FAIL
        end_proc,

        "DOM_SET"=
        proc(bset, S)
          local splitset;
        begin
        splitset:=split(S, x -> not has(x, infinity) and is(x in bset));
          if op(splitset,2)={} and op(splitset,3)={} then
            bset
          else
            hold(_union)(splitset[2] union splitset[3], bset)
          end_if
        end_proc,


        // Dom::ImageSet: handled there
      
        "Dom::Interval" =
        proc(bset, iv)
        begin
          if bset=R or bset=C then
            bset
          else
            FAIL
          end_if
        end_proc,

        "Dom::Multiset"=
        proc()
          name BasicSet_union;
        begin
          error("This would be an infinite multiset")
        end_proc,

        "piecewise" = proc() begin piecewise::_union(args()); end_proc
        );



  // inhomogleft_minus: methods that handle basic set minus other set

  inhomogleft_minus:=
  table(
        DOM_SET=
        proc(bset, S: DOM_SET)
          local newS: DOM_SET;
        begin
          newS:=select(S, x-> is(x in bset)<>FALSE );
          if newS={} then
            bset
          else
            hold(_minus)(bset, newS)
          end_if
        end_proc,

        Dom::Interval=
        proc(bset, iv:Dom::Interval)
          local switch: DOM_PROC;
        begin
          switch:=
          proc(x)
          begin
            if type(x)=DOM_LIST then
              op(x, 1)
            else
              [x]
            end_if
          end_proc;
          
          if bset=R then
            Dom::Interval(-infinity, switch(Dom::Interval::leftB(iv)))
            union
            Dom::Interval(switch(Dom::Interval::rightB(iv)), infinity)
          elif bset<>C then
            if Dom::Interval::left(iv)=-infinity or
              Dom::Interval::right(iv)=infinity then
              return(bset intersect (R_ minus iv)) 
            end_if;
            FAIL
          else
            FAIL
          end_if
        end_proc,

        DOM_EXPR=proc( bset : solvelib::BasicSet, xpr : DOM_EXPR )
        begin
          if not testtype( xpr, "_intersect" ) then return( hold(_minus)(bset, xpr ) ); end_if;
          xpr := select( xpr, X->X<>bset );
          if not testtype(xpr, "_intersect")  then return( _minus( bset, xpr ) ); end_if;
          return( hold( _minus)( bset, xpr ) );
        end_proc,

        piecewise=piecewise::_minus
          );

  // inhomogright_minus: table of methods for handling
  // "other set minus BasicSet""

  inhomogright_minus:=
  table(
        DOM_EXPR=
        proc(xpr, bset)

        begin
          if bset=C then
            return({})
          end_if;
          case type(xpr)
            of "_union" do
            of "_intersect" do
              return(map(xpr, _minus, bset))
            of "_minus" do
              return(op(xpr,1) minus (op(xpr,2) union bset))
            otherwise
              FAIL
          end_case;
        end_proc,

        DOM_SET=
        proc(S: DOM_SET, bset: solvelib::BasicSet)
          local splitset;
        begin
          if bset=C then
            return({})
          end_if;
          splitset:= split(S, u-> is(u in bset));
          if op(splitset,3)={} then
            op(splitset,2)
          else
            op(splitset,2) union hold(_minus)(op(splitset,3), bset)
          end_if
        end_proc,

        Dom::Interval=
        proc(J: Dom::Interval, bset: solvelib::BasicSet)
        begin
          if bset=C or bset=R then
            {}
          else
            FAIL
          end_if
        end_proc
        );


// _plus, _mult, _minus, special functions

homog_plus:= () -> dom::homog_union(args());

homog_mult:= () -> dom::homog_union(args());

inhomog_plus:=
table(
      "DOM_INT"= ((bset,n) -> bset),

      "DOM_RAT"=
      proc(bset, r)
        local i;
      begin
        if bset=Z then
          i:=genident();
          Dom::ImageSet(i+(op(r,1) mod op(r,2)) / op(r,2), i, Z)
        else
          bset
        end_if
      end_proc,


      "DOM_IDENT"= plusexpr,

      "DOM_EXPR"= plusexpr,

      "DOM_FLOAT" = plusexpr,

      "DOM_COMPLEX"= plusexpr,

      "DOM_SET"=
      proc(bset, S)
        local i;
      begin
        _union(bset + op(S,i) $i=1..nops(S))
      end_proc,

      "Dom::Interval"=
      proc(bset, iv)
      begin
        if bset=R or bset=Q then
          R
        elif bset=C then
          C
        else
          FAIL
        end_if
      end_proc,

      "Dom::ImageSet"=
      proc(bset, iset)
      begin
        if bset=C then
          C
        else
          genident();
          Dom::ImageSet(expr(iset)+%, append(iset::dom::variables(iset), %),
                        append(iset::dom::sets(iset), bset))
        end_if
      end_proc,

      "piecewise"=
      proc(bset, pw)
      begin
        piecewise::extmap(pw, _plus, bset)
      end_proc
        );


inhomog_mult:=
table(
      DOM_INT=
      proc(bset, n)
        local u;
      begin
        if n=0 then
          return({0})
        end_if;
        if bset<>Z then
          return(bset)
        end_if;
        if n=1 or n=-1 then
          Z
        else
          u:=genident();
          Dom::ImageSet(n*u, u, Z)
        end_if
      end_proc,

      DOM_RAT = multexpr,

      DOM_EXPR=
      proc(bset, xpr)
        local x1, x2;
      begin
        if testtype(xpr, Type::Arithmetical) then 
          multexpr(bset, xpr)
        elif testtype(xpr, Type::Set) then
          x1:= genident():
          x2:= genident();
          Dom::ImageSet(x1*x2, [x1, x2], [bset, xpr])
        else
          error("Illegal argument")
        end_if 
      end_proc,  

      DOM_IDENT=multexpr,

      DOM_COMPLEX=multexpr,

      DOM_FLOAT=multexpr,

      DOM_SET=
      proc(bset, S)
        local i;
      begin
        _union(bset * op(S,i) $i=1..nops(S))
      end_proc,

      "Dom::ImageSet"=
      proc(bset, iset)
      begin
        if bset=C then
          C
        else
          genident();
          Dom::ImageSet(expr(iset)*%, append(iset::dom::variables(iset), %),
                        append(iset::dom::sets(iset), bset))
        end_if
      end_proc,

      "piecewise"=
      proc(bset, pw)
      begin
        piecewise::extmap(pw, _mult, bset)
      end_proc
        );

_negate:=id;


bin_power:=
proc(bset1, bset2)
begin
  if bset2 <> Z then
    return(C)
  end_if;
  if bset1 <> Z then
    return(bset1)
  end_if;
  Z_ union Dom::ImageSet(1/#k, #k, Z)
end_proc;

inhomogleft_power:=
table(
      DOM_INT=
      proc(bset, n)
        local u;
      begin
        if n=0 then
          return({1})
        end_if;
      if n=1 then
        return(bset)
      end_if;
      if bset=C then
        if n>0 then
          return(bset)
        else
          return(bset minus {0})
        end_if
      end_if;
      if bset=Z or bset=Q then
        u:=genident();
        return(Dom::ImageSet(u^n, u, bset))
      end_if;
      /* bset = R */
      if n mod 2= 1 then
        bset
      else
        Dom::Interval([0], infinity)
      end_if
      end_proc,

      DOM_RAT=
      proc(bset, q)
        local u;
      begin
        if bset=C then
          return(bset)
        end_if;
      if bset=Z or bset=Q then
        u:=genident();
        return(Dom::ImageSet(u^q, u, bset))
      end_if;
      /* bset = R */
        u:=genident();
      return(hold(_union)(Dom::Interval([0], infinity),
                          Dom::ImageSet((-1)^q * u, u,
                                        Dom::Interval([0], infinity)) ))
      end_proc


        );


inhomogright_power:=
table(
      DOM_INT=
      proc(n, bset)
        local u;
      begin
        if n=0 then
          return({0,1})
        end_if;
      if n=1 then
        return({1})
      end_if;
      case bset
        of C do
          return(C minus {0})
        of R do
          if n>0 then
            return(Dom::Interval(0, infinity))
          elif n=-1 then
            return(exp(I*R))
          else
            u:= genident();
            return(Dom::ImageSet(n^u, u, R))
          end_if
        of Q do
          u:=genident();
          return(Dom::ImageSet(n^u, u, Q))
        of Z do
          if n=-1 then
            return({-1, 1})
          end_if;
          u:=genident();
          return(Dom::ImageSet(n^u, u, Z))
      end_case
      end_proc



      );

spfun:=
proc(u)
  option escape, hold;
begin
  /* return value : */
  proc(S)
    local newvar:DOM_IDENT;
  begin
    newvar:=genident();
    Dom::ImageSet(context(u)(newvar), newvar, S)
  end_proc;

end_proc;

exp :=
proc(bs)
begin
  case bs
    of R_ do
      return( Dom::Interval( 0, infinity ) )
    of C_ do
      return( C_ minus {0} )
  end_case;
  bs::dom::map( bs, exp )
end_proc;

_invert:= loadproc(solvelib::BasicSet::_invert, path, "_invert");

sin:=loadproc(solvelib::BasicSet::sin, path,
                                         "sin");
cos:= loadproc(solvelib::BasicSet::cos, path,
                                         "cos");
arctan:= loadproc(solvelib::BasicSet::arctan, path,
                                         "arctan");

tan := loadproc(solvelib::BasicSet::tan, path, "tan");

arcsin:= loadproc(solvelib::BasicSet::arcsin, path, "arcsin");
arcsinh:= loadproc(solvelib::BasicSet::arcsinh, path, "arcsinh");
arg:= loadproc(solvelib::BasicSet::arg, path, "arg");
abs:= loadproc(solvelib::BasicSet::abs, path, "abs");


arccos:=dom::spfun(arccos);
sign:=dom::spfun(sign);
signIm:=dom::spfun(signIm);

ceil:= dom::spfun(ceil);
dirac:=dom::spfun(dirac);
floor:= dom::spfun(floor);
heaviside:=dom::spfun(heaviside);
frac:= loadproc(solvelib::BasicSet::frac, path, "frac");
round:=proc(set) begin if set=Z_ then return(Z_); end_if; Dom::ImageSet(round(#x, args(2..args(0))), #x, set) end_proc;
trunc:= dom::spfun(trunc);

expr:= x -> extop(x,1);

normal:= x -> x;

// print should never be reached since the four possible values are in the remember table
print:= x -> error("body should never be reached");

TeX:= x -> "\\mathbb ".((expr2text(dom::print(x)))[1]);


indets:= {};
freeIndets:={};

contains:=
proc(X: dom, x)
begin
  case X
    of Z_ do
      return(is(x, Type::Integer))
    of Q_ do
      return(is(x, Type::Rational))
    of R_ do
      return(is(x, Type::Real))
    of C_ do
      return(testtype(x, Type::Arithmetical))
  end_case
end_proc;


isEmpty:=FALSE;

isFinite:=FALSE;

card:= infinity;

preferredPrefix:=
table(
      Z = "k",
      R = "lambda",
      Q = "r",
      C = "z"
      );

// overload solvelib::substituteBySet
// substituteBySet(a, x, S) - returns { a(y): y \in S } for given a(x)
substituteBySet:=
proc(a, x, S: solvelib::BasicSet)
begin
  // simple implementation
  genident(dom::preferredPrefix[S]);
  Dom::ImageSet(subs(a, x=%), %, S)
end_proc;

// overload solvelib::getElement : zero is in every basic set

getElement:=
proc(S: dom)
begin
  if args(0) = 2 then
    if args(2) <> Random then
      error("Illegal option")
    end_if;
    assert(contains({Z_, Q_, R_, C_}, S)); // no other basic sets exist
    case S
      of Z_ do
        Dom::Integer::random();
        break
      of Q_ do
        Dom::Rational::random();
        break
      of R_ do
        Dom::Real::random();
        break
      of C_ do
        Dom::Complex::random();
        break
     end_case;
  else
    // zero is in every basic set
    0
  end_if
end_proc;

// overload solvelib::Union: no basic set depends on any parameter, but
// we have to take care that xset might be empty
Union:=
proc(bset, x, xset)
  local empty;
begin
  empty:= solvelib::isEmpty(xset);
  piecewise([empty, {}],
            [not empty, bset])
end_proc;

// overload hull
hull:=
proc(bset)
begin
  if bset = C_ then 
    hull(RD_NINF, RD_INF) + hull(RD_NINF, RD_INF)*I
  else
    hull(RD_NINF, RD_INF)
  end_if
end_proc;



  /*  e n d    o f     m e t h o d s  */


begin

  /* l o c a l  f u n c t i o n s  */


  // plusexpr: add basic set and DOM_IDENT/DOM_EXPR/..

  plusexpr:=
  proc(bset, xpr)
    local u,v;
  begin
    if testtype(xpr, Type::Arithmetical) = TRUE then
      case bset
        of C do
          return(C)
        of R do
          if is(xpr, Type::Real)=TRUE then
            return(R)
          else
            u:=genident();
            if length((v:=Im(xpr)))>length(xpr) then
              v:=xpr
            else
              v:=I*v
            end_if;
            return(Dom::ImageSet(v+u, u, R))
          end_if
        of Q do
          if is(xpr, Type::Rational)=TRUE then
            return(Q)
          else
            u:=genident();
            /* simplify xpr by removing some subexpressions ? */
            return(Dom::ImageSet(xpr+u, u, Q))
          end_if
        of Z do
          if is(xpr,Type::Integer)=TRUE then
            return(Z)
          else
            u:=genident();
            return(Dom::ImageSet(xpr+u,u, Z) )
          end_if
      end_case;
    end_if;
    if type(xpr) = "_union" then
      return(map(xpr, _plus, bset))
    end_if;
    // cannot handle this
    FAIL
  end_proc;


  // multexpr - mult basic set and DOM_IDENT/DOM_EXPR

multexpr:=
proc(bset, xpr)
  local u,v;
begin
  if testtype(xpr, Type::Arithmetical) = TRUE then
    case bset
      of C do
        return(piecewise([xpr<>0, C], [xpr=0, {0}]))
      of R do
        if is(xpr, Type::Real)=TRUE then
          return(piecewise([xpr<>0, R], [xpr=0, {0}]))
        else
          u:=genident();
          // try to get vector of norm 1 (hopefully simpler ..)
          if length((v:=sign(xpr)))>length(xpr) then
            v:=xpr
          end_if;
          return(Dom::ImageSet(v*u, u, R))
        end_if
      of Q do
        if is(xpr, Type::Rational)=TRUE then
          return(piecewise([xpr<>0, Q], [xpr=0, {0}]))
        else
          u:=genident();
          return(Dom::ImageSet(xpr*u, u, Q))
        end_if;
      of Z do
        u:=genident();
        return(Dom::ImageSet(u*xpr, u, Z))
    end_case;
  end_if;
  if type(xpr) = "_union" then
    map(xpr, _mult, bset)
  else
    FAIL
  end_if
end_proc;

end_domain:

// values for special functions


solvelib::BasicSet::bin_minus(Z, R) := {}:
solvelib::BasicSet::bin_minus(Q, R) := {}:
solvelib::BasicSet::bin_minus(Z, Q) := {}:

solvelib::BasicSet::_subset(C, R) := FALSE:
solvelib::BasicSet::_subset(C, Q) := FALSE:
solvelib::BasicSet::_subset(C, Z) := FALSE:
solvelib::BasicSet::_subset(R, Q) := FALSE:
solvelib::BasicSet::_subset(R, Z) := FALSE:
solvelib::BasicSet::_subset(Q, Z) := FALSE:
solvelib::BasicSet::_subset(R, C) := TRUE:
solvelib::BasicSet::_subset(Q, C) := TRUE:
solvelib::BasicSet::_subset(Z, C) := TRUE:
solvelib::BasicSet::_subset(Z, R) := TRUE:
solvelib::BasicSet::_subset(Q, R) := TRUE:
solvelib::BasicSet::_subset(Z, Q) := TRUE:


solvelib::BasicSet::sign(Q):={-1,0,1}:
solvelib::BasicSet::sign(R):={-1,0,1}:

solvelib::BasicSet::sign(Z):={-1,0,1}:
solvelib::BasicSet::sign(Q):={-1,0,1}:
solvelib::BasicSet::sign(R):={-1,0,1}:
solvelib::BasicSet::signIm(Z):={-1,0,1}:
solvelib::BasicSet::signIm(Q):={-1,0,1}:
solvelib::BasicSet::signIm(R):={-1,0,1}:
solvelib::BasicSet::signIm(C):={-1,0,1}:


solvelib::BasicSet::ceil(Z):= Z:
solvelib::BasicSet::ceil(Q):= Z:
solvelib::BasicSet::ceil(R):= Z:

solvelib::BasicSet::dirac(Z):= {0, dirac(0)}:
solvelib::BasicSet::dirac(Q):= {0, dirac(0)}:
solvelib::BasicSet::dirac(R):= {0, dirac(0)}:

solvelib::BasicSet::floor(Z):= Z:
solvelib::BasicSet::floor(Q):= Z:
solvelib::BasicSet::floor(R):= Z:

solvelib::BasicSet::heaviside(Z):= {0, 1, heaviside(0)}:
solvelib::BasicSet::heaviside(Q):= {0, 1, heaviside(0)}:
solvelib::BasicSet::heaviside(R):= {0, 1, heaviside(0)}:

solvelib::BasicSet::print(R):=hold(R_):
solvelib::BasicSet::print(Z):=hold(Z_):
solvelib::BasicSet::print(Q):=hold(Q_):
solvelib::BasicSet::print(C):=hold(C_):

solvelib::BasicSet::round(Q):= Z:
solvelib::BasicSet::round(R):= Z:

solvelib::BasicSet::trunc(Z):= Z:
solvelib::BasicSet::trunc(Q):= Z:
solvelib::BasicSet::trunc(R):= Z:

solvelib::BasicSet::_plus(Z, Z) := Z:
solvelib::BasicSet::_plus(Q, Z) := Q:
solvelib::BasicSet::_plus(Z, Q) := Q:
solvelib::BasicSet::_plus(Q, Q) := Q:
solvelib::BasicSet::_plus(Z, R) := R:
solvelib::BasicSet::_plus(Q, R) := R:
solvelib::BasicSet::_plus(R, R) := R:
solvelib::BasicSet::_plus(R, Z) := R:
solvelib::BasicSet::_plus(R, Z) := R:
solvelib::BasicSet::_plus(C, Z) := C:
solvelib::BasicSet::_plus(C, Q) := C:
solvelib::BasicSet::_plus(C, R) := C:
solvelib::BasicSet::_plus(C, C) := C:
solvelib::BasicSet::_plus(Z, C) := C:
solvelib::BasicSet::_plus(Q, C) := C:
solvelib::BasicSet::_plus(R, C) := C:

solvelib::BasicSet::_mult(Z, Z) := Z:
solvelib::BasicSet::_mult(Q, Z) := Q:
solvelib::BasicSet::_mult(Z, Q) := Q:
solvelib::BasicSet::_mult(Q, Q) := Q:
solvelib::BasicSet::_mult(Z, R) := R:
solvelib::BasicSet::_mult(Q, R) := R:
solvelib::BasicSet::_mult(R, R) := R:
solvelib::BasicSet::_mult(R, Z) := R:
solvelib::BasicSet::_mult(R, Z) := R:
solvelib::BasicSet::_mult(C, Z) := C:
solvelib::BasicSet::_mult(C, Q) := C:
solvelib::BasicSet::_mult(C, R) := C:
solvelib::BasicSet::_mult(C, C) := C:
solvelib::BasicSet::_mult(Z, C) := C:
solvelib::BasicSet::_mult(Q, C) := C:
solvelib::BasicSet::_mult(R, C) := C:

//////////////////////////////////////////////////////////////////////
//       define basic sets
//////////////////////////////////////////////////////////////////////

Z_ := solvelib::BasicSet(Dom::Integer):
Q_ := solvelib::BasicSet(Dom::Rational):
R_ := solvelib::BasicSet(Dom::Real):
C_ := solvelib::BasicSet(Dom::Complex):
N_ := hold(_intersect)(Z_, Dom::Interval([1], infinity)):


solvelib::BasicSet::Re := 
proc( set )
begin
  assert(contains({Z_, Q_, R_, C_}, set));
  case set
    of Q_ do return( Q_ );
    of R_ do return( R_ );
    of Z_ do return( Z_ );
    of C_ do return( R_ );
  end_case:
  // NOT REACHED 
end_proc:
