// solvelib::_equal(A, B)
// test equality of sets, and return an expression equivalent to A = B 


solvelib::_equal:=
proc(A: Type::Union(Type::Set, "_in"), B: Type::Union(Type::Set, "_in"))

begin
  if A = B then
    return(TRUE)
  end_if;
  
  if A::dom::_equal <> FAIL then
    return(A::dom::_equal(A, B))
  end_if;

  if B::dom::_equal <> FAIL then
    return(B::dom::_equal(B, A))
  end_if;
  
  // methods for kernel types

  if type(A) = type(B) then

    case type(A)
      of "_in" do  
      of "_intersect" do
      of "_union" do
      of "_minus" do
        // hope that the sorting is good ...
        zip([op(A)], [op(B)], solvelib::_equal);
        if {op(%)} = {TRUE} then
          return(TRUE)
        else
          break
        end_if
    end_case;
    
  end_if; // type(A) = type(B)

  return(A=B)
end_proc:


