//   


// solvelib::bound2Free

/* take a solution from the system solver
and convert the n-th component into a free parameter var
that is, [a_1, .., a_n,.., a_m] becomes

[a_1, ..., a_{n-1}, a_{n+1}, ..., a_m] subject to the condition var = a_n


the output is (usually) an object of type piecewise
*/

solvelib::bound2Free:=
proc(sol, n, var)
  local 
  v, cond,
  varlist: DOM_LIST,
  vset: DOM_SET,
  sets: DOM_LIST;

  
begin

  case type(sol)
    of "_union" do
    of "_intersect" do
    of "_minus" do
      sets:= map([op(sol)], solvelib::bound2Free, n, var);
      if contains(sets, FAIL) > 0 then
        return(FAIL)
      else
        return(eval(op(sol, 0))(op(sets)))
      end_if
    of "Union" do
      sets:= solvelib::bound2Free(op(sol, 1), n, var);
      if sets = FAIL then 
        return(FAIL)
      else
        return(solvelib::Union(sets, op(sol, 2..nops(sol))))
      end_if
    of piecewise do
      return(piecewise::extmap(sol, solvelib::bound2Free, n, var))
    of "solve" do
      varlist:= op(sol, 2);
      assert(type(varlist) = DOM_LIST);
      delete varlist[n];
      // eliminate free params from variables to solve for
      return(subsop(sol, 2 = varlist))
    of DOM_SET do
      return(_union
             (op(map(sol,
                     proc(vec)
                       local cond;
                     begin
                       cond:= var = vec[n];
                       vec:= (vec::dom)::delRow(vec, n);
                       piecewise([cond, {vec}],
                                 [not cond, {}])
                     end_proc
                     ))
              ))
    of solvelib::VectorImageSet do
      // given that [x1, ..., xm] is in
      // {[f1(lambda), ..., fm(lambda)]; lambda in S}
      // if xm is to become free, we have to restrict S to those
      // lambda's that satisfy fm(lambda) = xm
      v:= expr(sol);
      varlist:= sol::dom::variables(sol);
      vset:= {op(select(varlist, x-> has(v[n], x)))};
      if nops(vset) = 0 then // component is independent
        cond:= var = v[n];
        v:= (v::dom)::delRow(v, n);
        sets:= sol::dom::sets(sol);
        return(piecewise([cond, solvelib::VectorImageSet(v, varlist, sets)],
                         [not cond, {}]
                        )
               )
      elif nops(vset) = 1 then
        sets:= sol::dom::sets(sol);
        sets:= subsop(sets,
                      contains(varlist, op(vset)) =
                      solve(var = v[n], op(vset)) intersect
                      op(sol::dom::sets(sol), 1))         
      else
        userinfo(5, "Cannot handle image sets with more than one dependent component");
        return(FAIL)
      end_if;
      v:= (v::dom)::delRow(v, n);
      return(solvelib::VectorImageSet(v, varlist, sets))
    of stdlib::Undefined do
      return(undefined)
    of solvelib::cartesianPower do
      return(piecewise
             ([var in op(sol, 1),
               solvelib::cartesianPower(op(sol, 1), op(sol, 2)-1)],
              [not var in op(sol, 1), {}])
             )
  end_case;

  userinfo(5, "Cannot handle this type of set");
  FAIL

end_proc:

