

/*
   solvelib::cartesianProduct()

      returns the cartesian product of subsets of C^n
      (for possibly different n)

*/

solvelib::cartesianProduct:=
proc()
  local argv, flatten, genericElement, variables, sets, i, d, X;
  save MAXEFFORT;
begin
  
  flatten:=
  proc(S)
  begin
    map(S, map, l-> if domtype(l) = DOM_LIST or domtype(l) = matrix then
                      op(l)
                    else
                      l
                    end_if)
  end_proc;
  
  argv:= [args()];

  if testargs() then
    if (i:= contains(map(argv, testtype, Type::Set), FALSE)) > 0 then
      error("Arguments must be sets but ".expr2text(argv[i])." is not")
    end_if
  end_if;

  
  if contains(argv, undefined) > 0 then
    return(undefined)
  end_if;

  
  argv:= map(argv, S -> if type(S) = solvelib::cartesianPower then
                          op(S, 1) $op(S,2)
                        else
                          S
                        end_if
             );

  // prefer to write a cartesian power
  if nops({op(argv)}) = 1 then
    return(solvelib::cartesianPower(op(argv, 1), nops(argv)))
  end_if;
  
  
  // handle cartesianProducts in the arguments

  /*
  argv:= map(argv, S -> if type(S) = "solvelib::cartesianProduct" then
                          op(S)
                        else
                          S
                        end_if
             );
*/

  
  if contains(argv, {}) > 0 then
    return({})
  end_if;

  // apply the distributive law to _union (but not to intersect because
  // of possible infinite recursions)
  d:= map(argv, type);
 
  if (i:= contains(d, "_intersect")) > 0 and MAXEFFORT > 100*nops(argv[i]) then
    MAXEFFORT:= MAXEFFORT/nops(argv[i]);
    return(solvelib::solve_intersect(solvelib::cartesianProduct(op(argv, 1..i-1), X,
                                                 op(argv, i+1..nops(argv)))
                      $X in argv[i]
                      ))
  end_if;
 

  if (i:= contains(d, "_union")) > 0 then
    MAXEFFORT:= MAXEFFORT/nops(argv[i]);
    return(solvelib::solve_union(solvelib::cartesianProduct(op(argv, 1..i-1), X,
                                             op(argv, i+1..nops(argv)))
                  $X in argv[i]
                  ))
  end_if;
  if (i:= contains(d, piecewise)) > 0 then
    return(piecewise::extmap
           (argv[i], X ->
            solvelib::cartesianProduct(op(argv, 1..i-1), X,
                                       op(argv, i+1..nops(argv)))
            ))
  end_if;
  
  
  variables:= sets:= [];
  genericElement:= [NIL $ nops(argv)];
  
  for i from 1 to nops(argv) do
    // obtain a formula for the set of "general elements"" of argv[i]
    case type(argv[i])
      of DOM_SET do
        genericElement[i] := argv[i];
        break
      of Dom::ImageSet do
      of solvelib::VectorImageSet do
        d:= (argv[i])::dom;
        for X in {op(d::variables(argv[i]))} intersect {op(variables)} do
          argv[i]:= d::changevar(argv[i], X, genident())
        end_for;
        genericElement[i] := {expr(argv[i])};
        variables:= variables.d::variables(argv[i]);
        sets:= sets.d::sets(argv[i]);
        break
      otherwise
        if solvelib::dimension(argv[i]) <> 1 then
          return(procname(args()))
        end_if;
        X:= genident();
        genericElement[i] := {X};
        variables:= variables.[X];
        sets:= sets.[argv[i]]
    end_case
  end_for;


  map({op(flatten(combinat::cartesianProduct(op(genericElement))))}, matrix);

  if nops(sets) = 0 then
    %
  else
    _union(op(
              map(%,
                  el -> solvelib::VectorImageSet(el, variables, sets))
              ))
  end_if

end_proc:


solvelib::cartesianProduct:= funcenv(solvelib::cartesianProduct):
solvelib::cartesianProduct::type := "cartesianProduct":