/*
   solvelib::checkSolutions(sol, equ, x, options)

   given a set sol of solutions to equation equ that might contain too many
   solutions, select the correct ones

   output a warning if there might be still too many

*/

solvelib::checkSolutions:=
proc(sol, equ: "_equal", x, options)
  local checkSolutionsInternal: DOM_PROC, 
        warn: DOM_BOOL;
begin
        

  /*
    local method checkSolutionsInternal
    checks sol, and sets warn to TRUE if there might be spurious solutions
  */
  
  checkSolutionsInternal:=
  proc(sol)
    local result, i, cond;
  begin  
    
    case type(sol)
    of piecewise do
      return(piecewise::extmap(sol, checkSolutionsInternal, equ, x, options))
    of "_union" do
    of "_intersect" do
      return(map(sol, checkSolutionsInternal, equ, x, options))
    of "_minus" do
      return(checkSolutionsInternal(op(sol, 1), equ, x, options)
      minus
      op(sol, 2)
      )
    of "solve" do 
      // could not solve eq - ok
      return(sol)
    of DOM_SET do
      if options[IgnoreAnalyticConstraints] then
        equ:= op(equ, 1) - op(equ, 2);
        return(select(sol,
        proc(s)
          local res;
        begin
          _lazy_or(
          hastype(sol, rationalize::hardToEval),
          _lazy_and
          (
          traperror
          ((
          res:= numeric::isnonzero(evalAt(equ, x=s))
          )) = 0,
          res <> TRUE
          )
          )
        end_proc
        )
        )
      end_if;
      result:= {};
      for i from 1 to nops(sol) do
        if traperror((cond:= (equ | x=op(sol, i)))) = 0 then
          result:= result union
          piecewise([cond, {op(sol, i)}],
          [not cond, {}]
          )
        end_if
      end_for;
      return(result)
    end_case;
    warn:= TRUE;  
    sol 
  end_proc;
  
  warn:= FALSE;
  sol:= checkSolutionsInternal(sol);
  
  // default
  if warn and not options[NoWarning] and not options[IgnoreAnalyticConstraints] then
    warning("Possibly spurious solutions")
  end_if;
  sol
end_proc:
  
// end of file

