
/***********************************************************
solvelib::completeLinearSolution

sol - a solution produced by linsolve(..., ShowAssumptions)
newsys - the system that has been solved
unk - the unknowns
options - table of options

***********************************************************/



solvelib::completeLinearSolution:=
proc(sol, newsys, unk, options = solvelib::getOptions())
  local lcoefflist, cond1, cond2, branches, lc, pw, solutions, solutions2,
  i, syst;
option escape;

begin
  if options[IgnoreSpecialCases] then
    pw:= solvelib::ignoreSpecialCases
  else
    pw:= piecewise
  end_if;



    
  if contains(op(sol, 3), 0<>0) > 0 then
    // unsolvable
    return({})
  end_if;
  
  if op(sol, 1) = FAIL then
    solutions:= {}
  else
    solutions:= solvelib::vectorForm({op(sol, 1)}, unk)
  end_if;

    
  lcoefflist:= op(sol, 3);
  cond1:=_and(op(op(sol,2)));
  cond2:=_and(op(op(sol, 3)));

  solutions:= solvelib::avoidAliasProblem(solutions,
                                          indets([sol, lcoefflist, cond1, cond2]));

  
  if nops(lcoefflist) = 0 or options[IgnoreSpecialCases] then
    return(pw([cond1 and cond2,
               solutions],
              [not cond1, {}]))
  end_if;

  if MAXEFFORT < 10*length(newsys) then
    // the simple way ...
    return(pw([cond1 and cond2,
               solutions],
              [not cond1, {}],
              [cond1 and not cond2,
               hold(solve)(newsys, unk, solvelib::nonDefaultOptions(options))]
              )
           )
  end_if;
  
  assert(map({op(lcoefflist)}, type) = {"_unequal"});

  // replace a <> b by a-b
  lcoefflist:= map(lcoefflist, ineq -> op(ineq, 1) - op(ineq, 2));

  if contains(lcoefflist, 0) > 0 then
    // 0 <> 0 is impossible -> cond2 is FALSE
    return({})
  end_if;
  
  // try to split conditions a*b <> 0 into a<>0 and b<>0

  lcoefflist:= map(lcoefflist,
                   proc(a)
                     local f;
                   begin
                     f:= factor(a);
                     op(f, 2*i) $i=1..nops(f) div 2
                   end_proc
                   );

  lcoefflist:= select(lcoefflist, x -> (is(x<>0, Goal = TRUE) = FALSE));
  
  branches:=[[cond1 and cond2, solutions],
             [not cond1, {}]];
  // try to find out what happens if lc = 0 for as many elements
  // of lcoefflist as possible 

  i:= 1;
  while i<= nops(lcoefflist) do
    lc:= lcoefflist[i];

    // simple step
    if traperror((
                   syst:= subsex(newsys, lc=0)
                )) <> 0 then
      branches:= branches.
              [[lc = 0, {}]];
      i:= i+1;
      next
    elif syst <> newsys then
      syst:= eval(syst)
    end_if;       

    // reduce modulo lc
    syst:= property::normalGroebner(syst, [lc], 0);

    if has(syst, undefined) then
      branches:= branches.
               [[lc = 0, {}]];
      i:= i+1;
      next
    end_if;

    solutions:= numeric::linsolve(syst, unk, Symbolic, ShowAssumptions, 
                                  Iszero = (x -> iszero(property::normalGroebner(x, [lc]))),
                                  Normal = (x -> normal(x, Recursive = FALSE))
                                  );    
    /* solutions:= numeric::linsolve(syst, unk, hold(Symbolic),
                          hold(ShowAssumptions));
    */

    // reduce modulo lc again if enough effort available
    if MAXEFFORT < 10*length(solutions) then
      return(pw([cond1 and _and(op(map([op(lcoefflist, i..nops(lcoefflist))],
                               _unequal, 0))),
                 solutions],
                [not cond1, {}],
                [Otherwise, hold(solve)(syst, unk,
                                        solvelib::nonDefaultOptions(options))]
                )
             )
    else
      if traperror((solutions2:= subsex(solutions, lc = 0))) <> 0 then
        solutions:= undefined
      else  
        if solutions <> solutions2 then
          solutions2:= eval(solutions2)
        end_if;  
        solutions:= property::normalGroebner(solutions2, [lc], 0)
      end_if  
    end_if;

    if has(solutions, undefined) then
      solutions:= {}
    else
      solutions:= solvelib::completeLinearSolution
      (solutions, syst, unk, options) assumingAlso lc=0
    end_if;

    branches:= branches.
               [[lc = 0, solutions]];
    i:=i+1
  end_while;
    
          
  return(pw(op(branches)))
end_proc:
