/*    */

/*++


solvelib::conditionalSort(l)


sort a list l of expressions

the result is either a list (if the sorting is the same for all real
values the parameters can take on) or an object of type piecewise


++*/


solvelib::conditionalSort:=
proc(l:DOM_LIST)
local inds, var,indep,dep,dummy,i;
  
begin
  userinfo(2, "Conditional sorter called");
  userinfo(10, "List to sort is: ".expr2text(l));

  map(l, assumeAlso, Type::Real);
  
  inds:= freeIndets(l);
  userinfo(5, "The set of indeterminates is: ".expr2text(inds));
  
  if inds={} then
    return(prog::sort(l, Re@float))
  end_if;

  
  var:=op(inds,1);

  userinfo(5, "Choosing main variable ".expr2text(var));

  [dep, indep, dummy]:=split(l, has, var);
  assert(dummy = []); 

  userinfo(5, "Sorting the independent entries");

  indep:=solvelib::conditionalSort(indep);
  
  /* compare the dependent entries */

  for i in dep do

    /* insert i into indep */
    
    if type(indep)=piecewise then
      map([extop(indep)],
          proc(t:stdlib::branch)
          begin
            solvelib::conditionalinsert(t::dom::expression(t), i, var);
            if type(%)=DOM_LIST then
              piecewise([t::dom::condition(t), %])
            else
              piecewise::restrict(%, t::dom::condition(t))
            end_if
          end_proc);
      indep:=piecewise::_concat(op(%))
    elif indep = undefined then
      // case has been recognized as impossible
      userinfo(50, "Non-real element in list to be sorted");
      return(undefined)
    else /* type(indep)=DOM_LIST */
      indep:= solvelib::conditionalinsert(indep, i, var)      
    end_if;   
  end_for;

  return(indep)
  
end_proc:
  

/*++

solvelib::conditionalinsert(l, a, x)

l - DOM_LIST
a - expression
x - identifier

returns a sorted list consisting of a and the elements of l.
l must be a sorted list. If the sorting depends of the values of
identifiers occuring in a, an object of type piecewise is returned;
cases analysis is done w.r.t. the main variable x.                           

++*/


solvelib::conditionalinsert:=
proc(l:DOM_LIST, a, x)
  local i, cond, cases;

begin
  if l=[] then
    return([a])
  end_if;
  cases:=[];
  cond:= simplify::simplifyCondition(a<=l[1]);
  userinfo(10, "Determining interval of numbers satisfying ".
             expr2text(a<=l[1]));
  if cond <> FALSE then 
    cases:=append(cases, [cond, [a].l]);
  else
    userinfo(15, "Case ".expr2text(a<=l[1])." cannot occur")
  end_if;
  
  for i from 2 to nops(l) do
    cond:= simplify::simplifyCondition(a<= l[i] and a>l[i-1]);
    userinfo(10, "Determining interval of numbers satisfying ".
             expr2text(a<=l[i] and a>l[i-1]));
    if cond <> FALSE then
      cases:= append(cases, [cond,
                           [op(l,1..i-1)].[a].[op(l,i..nops(l))]])
    else 
      userinfo(15, "Case ".expr2text(a<= l[i] and a>l[i-1]).
               "cannot occur")
    end_if;
  
  end_for;
  
  cond:= simplify::simplifyCondition(a> l[nops(l)]);
  userinfo(10, "Determining interval of numbers satisfying ".
             expr2text(a>l[nops(l)]));
  if cond <> FALSE then 
    cases:=append(cases, [cond, append(l,a)])
  else
    userinfo(15, "Case ".expr2text(a>l[nops(l)]). " cannot occur")
  end_if;
  if nops(cases)=1 then
    op(cases[1],2)
  else
    piecewise::new(op(cases))
  end_if
  
end_proc:
                                
