
/*     */


/*

    solvelib::domsolve - solve over a domain

    solvelib::domsolve(eqs, var, options)

    eqs - equation, expression, or polynomial
    var - identifier
    options - table of options

*/


solvelib::domsolve:=
proc(eqs, var)
  local dm, i, p, options, newvar, newsys, sol, selectsol, vf: DOM_BOOL,
  list: DOM_BOOL;

begin
  options:=solvelib::getOptions(args(3..args(0)));
  dm:=options[Domain];


  // special case
  if contains({DOM_INT, Dom::Integer, Z_}, dm) then
    return(solvelib::diophantine(eqs, var, options))
  end_if;

  if dm = R_ then dm := Dom::Real end_if;

 


  // s y s t e m s
  
  if {DOM_LIST, DOM_SET} intersect {type(eqs), type(var)} <> {} then
    if type(var) = DOM_SET then
      var:= [op(var)];
      list:= FALSE
    elif type(var) <> DOM_LIST then
      var:= [var];
      list:= TRUE
    else
      list:= TRUE
    end_if;
    options[Domain] := hold(Expr);
    vf:= options[VectorFormat];
    options[VectorFormat] := TRUE;
    if type(dm) = DOM_DOMAIN then
      if dm::domsolve <> FAIL then
        sol:= dm::domsolve(eqs, var, options)
      elif testtype(dm, Type::Set) = TRUE then
        sol:= solve(eqs, var, options) intersect
              solvelib::cartesianPower(dm, nops(var))
      elif nops(var) = 1 and
        not contains({DOM_LIST, DOM_SET}, type(eqs)) then
        options[Domain]:= dm;
        sol:= solvelib::domsolve(eqs, op(var), options);
        sol:= solvelib::numberSetToVectorSet(sol)
      elif dm::hasProp(Cat::Field) = TRUE then
        if (newsys:= solvelib::solve_islinear(eqs, var, options)) <> FALSE then
          i:= linsolve(newsys, var, hold(Domain) = dm);
          if i = FAIL then
            sol:= {} /* no solution */
          else
            sol:= {map(i, op, 2)}
          end_if
        else
          error("Can only solve linear systems over that field")
        end_if
      else
        error("Cannot solve systems over that domain")
      end_if
    else
      error("Cannot solve systems over that domain")
    end_if;
    if vf then
      if list then
        return(sol)
      else
        return(hold(_in)(var, sol))
      end_if
    else
      return(solvelib::convertToAssignments(sol, var))
    end_if;
  end_if;



  // e q u a t i o n s
  
  if dm::dom::hasProp(Cat::Set)=TRUE then
    // solve over C and intersect with dm
    newvar:=genident();
    options[Domain] := hold(Expr);
    options[IgnoreProperties] := TRUE;
    sol:= solve(eqs, op(var, 1), options);

    selectsol:=
    proc(sol)
    begin
       sol intersect dm
    end_proc;


    if type(sol) = piecewise then
      return(piecewise::extmap(sol, selectsol))
    else
      return(selectsol(sol))
    end_if;
  end_if;
  if type(dm)<>DOM_DOMAIN then
    error("Right hand side of second argument must be a domain")
  end_if;


  if dm::domsolve <> FAIL then
    return(dm::domsolve(eqs, var, options))
  end_if;
  
    
  if contains( Type::ConstantIdents,var ) then
    error("Invalid variable (mathematical constant was given)")
  elif type(eqs)="_equal" then
    eqs:=op(eqs,1)-op(eqs,2)
  end_if;

  if iszero(eqs) then
    return(dm)
  end_if;
 

  // try to convert to polynomial

  p:=poly(eqs, [var], dm);
  if p = FAIL then
    if dm = Dom::Rational then
      options[Domain]:= Q_;
      return(solvelib::domsolve(eqs, var, options))
    end_if;
          
    error("Cannot convert to polynomial")
  end_if;

  if dm::solve_poly <> FAIL then
    return(dm::solve_poly(p, var, options))
  end_if;


if dm::hasProp(Cat::Field) <> TRUE then
  // dm is not a field (hasProp = FALSE) or
  // at least not known to be a field (hasProp = FAIL)
  // - we cannot proceed by factoring
  error("Cannot solve over that domain")
end_if;
  
/* try to find roots by factoring */

  userinfo(3, "Trying to factor");
  
  if traperror((p:=factor(p)))<>0 then
    error("Cannot solve over that domain")
  end_if;

  if options[Multiple]=FALSE then
    p:=select({op(p,2*i) $i=1..nops(p) div 2},
              proc() begin degree(args(1))=1 end_proc );
    [op(map(p, _negate@(u->coeff(u,0))*_invert@lcoeff))];
    {op(select(%, proc() begin args(1)<>FAIL end_proc ))}
  else
    p:=select({[op(p,2*i),op(p,2*i+1)] $i=1..nops(p) div 2},
              proc() begin degree(op(args(1),1))=1 end_proc );
    p:=map(p, proc() begin subsop(args(1),
                                  1=_negate(coeff(args(1)[1],0))) end_proc );
    Dom::Multiset((op(p,[i,1]) $op(p,[i,2]))
                         $i=1..nops(p))
  end_if


end_proc:


