/*--
	solvelib::solve_eq
--*/

solvelib::solve_eq:=
proc(eq, x)
  local options, s, l, r, dummy, mapfloat: DOM_PROC,
  maxeffort, pw;
  save MAXEFFORT;
begin

  // local method mapfloat(S) -> converts arithmetical expressions in S to floats
  mapfloat:=
  proc(S)
    local result;
  begin
    case type(S)
      of "solve" do
        if traperror((result:= float(S))) = 0 then
          result
        else  
          subsop(S, 1 = float(op(S, 1)))
        end_if;
        break
      of "_union" do
      of "_intersect" do
      of "_minus" do
        map(S, mapfloat);
        break
      of piecewise do
        piecewise::extmap(S, mapfloat);
        break
      otherwise
        float(S)
    end_case
  end_proc;
  
  userinfo(3, "solve_eq called with equation ".expr2text(eq));

  if eq::dom::solve <> FAIL then
    return(eq::dom::solve(args()))
  end_if;
  
  options:=solvelib::getOptions(args(3..args(0)));

  if options[IgnoreSpecialCases] then
    pw:= solvelib::ignoreSpecialCases
  else
    pw:= piecewise::new
  end_if;

  
  // check for  easy cases first
  case domtype(eq)
    of DOM_INT do
    of DOM_FLOAT do
    of DOM_COMPLEX do  
      return((if iszero(eq) then
                if options[Multiple]=TRUE then
                  error("Infinitely many solutions, cannot create multiset")
                else
                  if options[Real] then
                    R_
                  else
                    C_
                  end_if
                end_if
              else
                {}
              end_if))
    of DOM_RAT do
      // there is no DOM_RAT representing zero
      return({})
           // some strange cases

    of stdlib::Infinity do
    of stdlib::CInfinity do
      return({})
  end_case;
  
  // cannot solve expressions containing infinity
  if has(eq, infinity) then
    userinfo(2, "Cannot solve equations containing infinities");
    return(hold(solve)(eq, x, solvelib::nonDefaultOptions(options)))
  end_if;

  if type(eq) <> DOM_POLY and not contains(indets(eq), x) 
     or type(eq) = DOM_POLY and not has(eq, x) then
    if options[IgnoreSpecialCases] or
      options[IgnoreAnalyticConstraints] then
      return({})
    elif options[Multiple] then
      return(pw([eq<>0, {}]))
    else
      if options[Real] then
        return(pw([eq=0, R_], [eq<>0, {}]))
      else
        return(pw([eq=0, C_], [eq<>0, {}]))
      end_if
    end_if
  end_if;
  
  // special cases
  // expressions containing RootOf's cannot be handled

  if hastype(eq, RootOf) then
    userinfo(2, "Cannot solve equations containing RootOf's");
    return(hold(solve)(eq, x))
  end_if;
  
  case domtype(eq)
    of DOM_IDENT do /* solve(x,x) or maybe solve(y,x) */
      return(solvelib::solve_poly_irred(poly(eq,[x]), x, options))
    of DOM_EXPR do
      if contains( Type::ConstantIdents,x ) then
        error("Invalid variable (mathematical constant was given)")
      elif type(x)=DOM_FUNC_ENV then
        error("cannot solve for ".expr2text(x))
      end_if;

      case type(eq)
        of "_mult" do
        // do *not* immediately call the polynomial solver
        // because expanding a product would be the worst thing
        // one could do
          userinfo(5, "Solving factors ".expr2text(op(eq))." separately");
          maxeffort:= MAXEFFORT/3;
          MAXEFFORT:= maxeffort/nops(eq);
          l:= map([op(eq)], solvelib::solve_eq, x, options);
          MAXEFFORT:= maxeffort;
          if options[IgnoreAnalyticConstraints] or not options[hold(DiscontCheck)] then
            l:= _union(op(l));
            return(solvelib::checkSolutions(l, eq=0, x, options))
          end_if;
          r:= discont(eq, x, undefined, options);
          return(solvelib::solve_minus(_union(op(l)), r, options))
        of "_power" do
          if is(op(eq,2) > 0)= FALSE then
            return({})
          end_if;
          if not has(op(eq,2), x) then
            userinfo(5, "Equation ".expr2text(eq)." reduces to ".
                     expr2text(op(eq,1)));
            l:= solvelib::solve_eq(op(eq,1), x, options);
            if options[Multiple]=TRUE then
              if type(op(eq, 2)) = DOM_INT then 
                return(_union(l $op(eq,2)))
              else
                error("Option multiple is only allowed for polynomial equations")
              end_if
            else
              return(piecewise([op(eq, 2) > 0, l],
                               [not op(eq, 2) > 0, {}]))
            end_if
          end_if;
          break
        of "_plus" do
          if testtype(eq,Type::PolyExpr(x)) then
            // test for special case f(x)^n = C
            // in this case, return the union of the sets
            // of solutions for f(x)=C^(1/n) + exp(2*PI*I*j/n)
            // for 0 <= j <= n-1

            [l, r, dummy]:= split(eq, has, x);
            if type(l) = "_mult" then
              [l, s, dummy]:= split(l, has, x)
            else
              s:= 1
            end_if;
            if type(l)= "_power" then
              // polynomial of special form x^n + r for some integer n
              if options[IgnoreAnalyticConstraints] and not is(s=0, Goal = TRUE) then
                s:= solvelib::purePolynomial(l, r/s, x, options)
              else  
                s := pw
                     ([s<>0, solvelib::purePolynomial(l, r/s, x, options)],
                      [s=0 and r=0, C_],
                      [s=0 and r<>0, {}]
                      )
              end_if
            else
              // polynomial has not special form
              // it may happen that we get an exponent overflow
              if traperror((l:= poly(eq, [x]) )) <> 0 or l = FAIL then 
                 return(hold(solve)(eq, x))
              else 
                 s := solvelib::solve_poly(l, x, options)
              end_if
            end_if;

            if options[Real] and type(s) = DOM_SET and
               has(s, {ln, log})
            then
              return(map(s, simplify))
            else
              return(s)
            end_if;
          end_if;
          break
        of "function" do
          return(hold(solve)(eq, x))
        of "_equal" do
          // this should not happen, as a=b should have become
          // a-b in the interface function solve
          assert(FALSE);
      end_case;
        
     
      // type(eq) is none of _mult, _plus, or _power, or eq is a sum
      // but not polynomial in x
      
      if options[Multiple]=TRUE then
        error("Option multiple is only allowed for polynomial equations")
      end_if;


      // handle floating-point input
  
      if stdlib::hasfloat(eq) then
        eq:= numeric::rationalize(eq);
        l:= solvelib::solve_eq(eq, x, options);
        return(mapfloat(l))
      end_if;


      
      // do *not* normalize here, because this would destroy
      // sums where some summands do not contain x

      l := solvelib::avoidAliasProblem(solvelib::isolate(eq, 0, x, options),
                                       {x});
      if options[Real] and type(l) = "solve" and has(l, hold(log)) then
        l:= rewrite(l, ln)
      end_if;

      if options[IgnoreAnalyticConstraints] then
        l:= solvelib::checkSolutions(l, eq=0, x, options)
      end_if;
      
      return(l)

    of DOM_POLY do
      return(solvelib::solve_poly(eq, x, options))

 
  end_case;
  // NOT REACHED

  warning("Unknown type of equation");
  assert(FALSE);
  return(hold(solve)(eq, x))

end_proc:



/* end of file */

