/* */
/*    */
/* */

/* solvelib::ineqs(inequation, va)

   solve inequation with respect to variable va

*/



solvelib::ineqs :=
proc(inequation, var: DOM_IDENT)
  local
  Lhs: Type::Arithmetical,
  Rhs: Type::Arithmetical,
  simpler: Type::Arithmetical,
  iv: Dom::Interval,
  sol: Type::Set,
  options: DOM_TABLE,
  border: DOM_PROC;

begin
  userinfo(3, "Inequality solver called for ".expr2text(inequation));

  assert(contains({"_less", "_leequal"}, type(inequation)));
  
  options:= solvelib::getOptions(args(3..args(0)));

  [Lhs, Rhs]:= [op(inequation)];

  if type(Lhs) = Series::Puiseux or type(Rhs) = Series::Puiseux then
	error("Cannot solve a series")
  end_if;

  if type(Lhs) = piecewise then
    // Rhs may also be piecewise: use zip
    return(solve(piecewise::zip(Lhs, Rhs, op(inequation, 0)), var, options))
  end_if;
  if type(Rhs) = piecewise then
    return(solve(piecewise::extmap(Rhs, u-> op(inequation, 0)(Lhs, u)),
                 var, options)
           )
  end_if;
  border:= if type(inequation) = "_less" then id else x->[x] end_if;
  
  // special case: infinity or -infinity
  if Rhs = -infinity or Lhs = infinity then
    return({})
  end_if;
  if Lhs = -infinity then
    return(solve(Rhs in R_, var, options))
  end_if;
  if Rhs = infinity then
    return(solve(Lhs in R_, var, options))
  end_if;
  

  // handle real mode separately
  if options[Real] then
    return(solvelib::ineqsReal(inequation, var, options))
  end_if;


  //
  //  beginning of the complex inequality solver
  //

  // handle constant inequalities first
  if not has(inequation, var) then
    return(piecewise([inequation, C_],
                     [not inequation, {}]))
  end_if;

  if not has(Rhs, var) then
    // solve f(x) < C or f(x) <= C
    iv:= Dom::Interval(-infinity, border(Rhs));
    case(is(Rhs in R_))
      of TRUE do
        return(solvelib::preImageInterval(Lhs, var, iv, options))
      of FALSE do
        return({})
      of UNKNOWN do
        sol:= piecewise::evalAssuming
        (
         solvelib::preImageInterval(Lhs, var, iv, options),
         Rhs in R_);
        if type(sol) <> "solve" then
          return(piecewise
                 ([not Rhs in R_, {}],
                  [Rhs in R_, sol]
                  )
                 )
        else
          return
          (
           hold(solve)(inequation, var, solvelib::nonDefaultOptions(options)
                       )
           )
        end_if
      end_case
  end_if;


  if not has(Lhs, var) then
    // solve f(x) > C or f(x) >= C
    iv:= Dom::Interval(border(Lhs), infinity);
    case(is(Lhs in R_))
      of TRUE do
        return(solvelib::preImageInterval(Rhs, var, iv, options))
      of FALSE do
        return({})
      of UNKNOWN do
        sol:= piecewise::evalAssuming
        (
         solvelib::preImageInterval(Rhs, var, iv, options),
         Lhs in R_):
        if type(sol) <> "solve" then
          return(piecewise
                 ([not Lhs in R_, {}],
                  [Lhs in R_, sol]
                  )
                 )
        else
          return
          (
           hold(solve)(inequation, var, solvelib::nonDefaultOptions(options)
                       )
           )
        end_if
    end_case;
  end_if;
  

  // in general, f(x) <= g(x) iff g(x) - f(x) in [0, infinity] and
  // one (and therefore both) of f, g are real

  // find out which of Lhs, Rhs is easier to handle 
  if Simplify::defaultValuation(Lhs) <= Simplify::defaultValuation(Rhs) then
    simpler:= Lhs
  else
    simpler:= Rhs
  end_if;

  simpler:= solvelib::preImageReal(simpler, var, options);

  save var;
  assume(var in simpler);
  sol:= solvelib::preImageInterval(Rhs - Lhs, var,
                              Dom::Interval(border(0), infinity), options):

  if type(sol) = "solve" then
    hold(solve)(inequation, var, solvelib::nonDefaultOptions(options))
  else  
    solvelib::solve_intersect
    (
     unfreeze(sol),
     unfreeze(simpler)
     )
  end_if
end_proc:
  
  

solvelib::ineqsys:=
proc(ineqs: DOM_LIST, var: DOM_LIST, options: DOM_TABLE)
  local sls;
  
begin
 
  // other cases are handled by solve
  assert(nops(var)>=2);

  sls:= solve(ineqs, [var[1]], options);
  if type(sls) = "solve" then
    return(hold(solve)(ineqs, var))
  end_if;
  assert(not has(sls, FAIL));
    
  solvelib::free2Bound(sls,
                         [op(var, 2..nops(var))],
                         options)
           
 end_proc:
                      

/* end of file */






























